#!/bin/bash
WGET_USER=MFISCHER
WGET_PASSWORD=P@ssw0rd*
WGET="/usr/bin/wget --user=$WGET_USER --password=$WGET_PASSWORD --no-check-certificate"
WGET_URLLIST=wsdl_urls.lst
WGET_OUTDIR=xml

WSIMPORT=/opt/java/jdk/bin/wsimport
ICONV=/usr/bin/iconv
BASEPKG=de.hallobtf.info.web19
WSDLLOCATION=/de/hallobtf/info/wsdl19/
WS_OUTDIR=../../../..


help()
{
	echo "Usage: `basename $0` [get_wsdl | generate_classes]"
}

get_wsdl()
{
	mkdir -p $WGET_OUTDIR
	rm -R $WGET_OUTDIR/*.xml
	mapfile -t WSDL_ARR < $WGET_URLLIST	
	for i in "${WSDL_ARR[@]}"
	do
		IF="`echo $i | tr -d '\r\n'`"
		OF="$WGET_OUTDIR/`basename $IF`"
		$WGET -nv -O $OF.xml $IF 
	done
}

generate_classes()
{
	for filename in $(find ../web19 -name "*.java"); do 
		rm -f $filename
	done

	for filename in $WGET_OUTDIR/*.xml; do 
		$WSIMPORT -encoding UTF8 -p $BASEPKG.`basename $filename .xml` -s $WS_OUTDIR -wsdllocation $WSDLLOCATION$filename $filename 
	done
	
	for filename in $(find ../web19 -name "*.java"); do 
		$ICONV -t iso-8859-1 -f utf-8 <"$filename" >"$filename".iso
	done
	for filename in $(find ../web19 -name "*.java.iso"); do 
		mv "$filename" `dirname "$filename"`/`basename "$filename" .iso`
	done
	for filename in $(find de/hallobtf/info/web19 -name "*.class"); do 
		rm "$filename"
	done
}

case "$1" in
get_wsdl)	
	get_wsdl
	;;
	
generate_classes)	
	generate_classes
	;;
	
*)
	help		
	;;
esac
exit 0	

