#!/bin/sh
SCRIPT=`basename $0`
ROOTPATH="$(dirname "$(readlink -f "$0")")"/..
MEM=1024
LOGLEVEL=100
LOGTOCONSOLE=false
LOGPREFIX=KaiServer
LOGDIR=$ROOTPATH/logs
LOGTHREAD=true
CHARSET=UTF-8
LANGUAGE=de
COUNTRY=de
REVISION=r19367

if test -f /etc/default/kai; then
    . /etc/default/kai
fi

if [ ! -z "$2" ]; then
	REVISION=$2
fi

if [ ! -z "$3" ]; then
	JRE=$3
fi

setEnv() {
    export PID=$ROOTPATH/$SCRIPT.pid 

    if [ $JRE ]; then
        export JAVA_BIN=$JRE/bin/java
    else
    	if [ -d $ROOTPATH/jre21 ]; then
	  	    export JAVA_BIN=$ROOTPATH/jre21/bin/java
	    else
		    export JAVA_BIN=`which java`  
	    fi    
    fi

    export JARS="$ROOTPATH/jars.$REVISION"
    export JARSADDON="$ROOTPATH/jars.addon"    
    export DUMPDIR="$ROOTPATH/dump"

    export CLASSPATH="$JARS/."
    if test -d $JARSADDON; then
    	for fn in $JARSADDON/*.jar; do
        	CLASSPATH="$CLASSPATH:$fn"  
    	done
    fi
    for fn in $JARS/*.jar; do
        CLASSPATH="$CLASSPATH:$fn"  
    done

    if [ $CHARSET ]; then
        OPT="$OPT -Dfile.encoding=$CHARSET"
    fi
    if [ $LANGUAGE ]; then
        OPT="$OPT -Duser.language=$LANGUAGE"
    fi
    if [ $COUNTRY ]; then
        OPT="$OPT -Duser.country=$COUNTRY" 
    fi
    if test -d $JARSADDON; then
        OPT="$OPT -Djava.library.path=$JARSADDON" 
    fi
    OPT="$OPT -Dpid=$PID"

    export EXEC="cd $ROOTPATH/server;$JAVA_BIN -Xrs -Xmx"$MEM"m -cp $CLASSPATH -DDumpDir=$DUMPDIR -DLogThread=$LOGTHREAD -DLogPrefix=$LOGPREFIX -DLogLevel=$LOGLEVEL -DLogToConsole=$LOGTOCONSOLE -DLogDir=$LOGDIR $OPT de/hallobtf/Kai/server/KaiServer $ROOTPATH/ini/Server.ini"
}

start() {
    echo -n "Starting $SCRIPT: "

    if [ -f $PID ]; then
        echo "$SCRIPT already running..."
        exit 1
    fi

    eval "$EXEC">/dev/null &
}

stop() {
    echo -n "Stopping $SCRIPT: "

    if [ ! -f $PID ]; then
        echo "$SCRIPT not running..."
        exit 1
    fi
    
    kill `cat $PID`
    rm $PID
    echo "done."
}

status() {
    echo -n "Checking for $SCRIPT: "

    if [ ! -f $PID ]; then
		echo "not running"
		exit 1
    else
		echo "running"
        exit 0
    fi  
}

run() {
    if [ -f $PID ]; then
        echo "$SCRIPT already running..."
        exit 1
    fi

    LOGTOCONSOLE=true
    setEnv
	
	trap stop HUP INT TERM    
    
    eval "$EXEC"
}

setEnv
if [ -f $PID ]; then
    (ps `cat $PID` 1>/dev/null 2>/dev/null) || rm $PID
fi

case "$1" in
    start)
        start
        ;;
    stop)
        stop
        ;;
    status)
        status
        ;;
    restart)
        stop
        sleep 10
        start
        ;;
    run)
        run
        ;;
    *)
        echo "Usage: $SCRIPT {start|stop|status|restart|run}" 
esac 

exit 0

