################################################################################
#
# Kai 02.03 
#
#
# Ab Version 2005-06-27 auf DB2-Kompatibiltät achten!!!
# Ab Version 2005-06-27 auf MSSQL-Kompatibiltät achten!!!
# Ab Version 2006-08-17 auf INFORMIX-Kompatibiltät achten!!!
# Ab Version 2007-07-31 auf POSTGRESQL-Kompatibiltät achten!!!
# Ab Version 2010-01-07 auf Oracle-UTF8-Kompatiblität achten !!!
# Ab Version 2010-01-09 kein Update auf btfsystem mehr notwendig!
#
# Ab Version 2017-01-01 keine Unterstützung mehr für
#						HSQLDBSQL
#						INFORMIX
#						POSTGRESQL
#						DB2
#
################################################################################
#
# Version 20250411
#

0:RUN de.hallobtf.Kai.utils.convert.CheckDatabaseType

0:CREATE TABLE btfsystem(dbversion int, lizenz clob(10000000), globalparams clob(10000000), infotext clob(64000))
0:CREATE TABLE bereich (mandant varchar(3), haushalt varchar(4), orgeinheit varchar(10), bereich varchar(4), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY (mandant,haushalt,orgeinheit,bereich))
0:CREATE TABLE etagen (mandant varchar(3), haushalt varchar(4), gebaeude varchar(10), etage varchar(4), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY (mandant,haushalt,gebaeude,etage))
0:CREATE TABLE freeitemsdef (mandant varchar(3), haushalt varchar(4), haupttyp varchar(3), untertyp varchar(3), name varchar(8), bezeichnung varchar(50), datatyp varchar(10), len int, scale int, withthousandseparator int,withleadingzeroes int,blankwhenzeroes int,withsign int,keyformat varchar(12),fillchar varchar(1),alignment varchar(12),dateformat varchar(10), numtyp varchar(10), rubrik varchar(8), pos int, pflichtfeld int, laptoppflichtfeld int, laptopsyncfeld int, suchfeldnr int, kategorie varchar(8), formel varchar(255), werte varchar(255), aufteilung varchar(20), retriever varchar(255), musterflag varchar(1), fremdschluessel varchar(50), bemerkung varchar(255), BUSINESS KEY (mandant,haushalt,haupttyp,untertyp,name))
0:CREATE TABLE gebaeude (mandant varchar(3), haushalt varchar(4), gebaeude varchar(10), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY(mandant,haushalt,gebaeude))
0:CREATE TABLE haupttypen (mandant varchar(3), haushalt varchar(4), haupttyp varchar(3), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY (mandant,haushalt,haupttyp))
0:CREATE TABLE mengeneinheit (mandant varchar(3), haushalt varchar(4), einheit varchar(3), bezeichnung varchar(100), BUSINESS KEY (mandant,haushalt,einheit))
0:CREATE TABLE rubrik (mandant varchar(3), haushalt varchar(4), rubrik varchar(8), bezeichnung varchar(100), pos int, bewegung int, aenderbar int, fsichtbar varchar(255), BUSINESS KEY(mandant,haushalt,rubrik))
0:CREATE TABLE orgeinheit (mandant varchar(3), haushalt varchar(4), orgeinheit varchar(10), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY(mandant,haushalt,orgeinheit))
0:CREATE TABLE raeume (mandant varchar(3), haushalt varchar(4), gebaeude varchar(10), etage varchar(4), raum varchar(6), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY (mandant,haushalt,gebaeude,etage,raum))
0:CREATE TABLE untertypen (mandant varchar(3), haushalt varchar(4), haupttyp varchar(3), untertyp varchar(3), bezeichnung varchar(100), fremdschluessel varchar(50), BUSINESS KEY (mandant,haushalt,haupttyp,untertyp))
0:CREATE TABLE bewegungen (mandant varchar(3), haushalt varchar(4), nummer varchar(30), rubrik varchar(8), lfdnr int, BUSINESS KEY(mandant,haushalt,nummer,rubrik,lfdnr))
0:CREATE TABLE bewcolvalue (mandant varchar(3), haushalt varchar(4), rubrik varchar(8), nummer varchar(30), lfdnr int, name varchar(8), value varchar(255),  BUSINESS KEY(mandant,haushalt,nummer,rubrik,lfdnr,name))
0:CREATE TABLE tabellen (mandant varchar(3), haushalt varchar(4), key1 varchar(50), key2 varchar(50), key3 varchar(50), key4 varchar(50), key5 varchar(50), key6 varchar(50), daten varchar(50), BUSINESS KEY(mandant, haushalt, key1, key2, key3, key4, key5, key6))
0:CREATE TABLE stapel (mandant varchar(3), haushalt varchar(4), userid varchar(50), modus varchar(1), nummer varchar(30), zuordnung varchar(1), BUSINESS KEY(mandant,haushalt,userid,modus,nummer))
0:CREATE TABLE inventar (mandant varchar(3), haushalt varchar(4), nummer varchar(30), haupttyp varchar(3), untertyp varchar(3), orgeinheit varchar(10), bereich varchar(4), invMuster varchar(30), bezeichnung varchar(50), beschreibung varchar(255), gebaeude varchar(10), etage varchar(4), raum varchar(6), kzAbgang varchar(1), datumZugang varchar(8), datumAbgang varchar(8), menge decimal(14,2), einheit varchar(3), freeitemsdata clob(64000), grundabgang varchar(100), abinummer varchar(10), aapplid varchar(4), anlkey varchar(40), noaanlbu varchar(1), batchnum varchar(18), iskoppelnummer varchar(1), datumletzteinvent varchar(8), datumerfassung varchar(8), datumstatusaenderung varchar(8), useridstatusaenderung varchar(50), withfoto varchar(1), BUSINESS KEY (mandant,haushalt,nummer))
0:CREATE TABLE inventartmp (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), gangnr varchar(3), nummer varchar(30), fremdschluessel varchar(50), haupttyp varchar(3), untertyp varchar(3), orgeinheit varchar(10), bereich varchar(4), invMuster varchar(30), bezeichnung varchar(50), beschreibung varchar(255), gebaeude varchar(10), etage varchar(4), raum varchar(6), kzAbgang varchar(1), datumZugang varchar(8), datumAbgang varchar(8), menge decimal(14,2), einheit varchar(3), freeitemsdata clob(64000), grundabgang varchar(100), aapplid varchar(4), anlkey varchar(40), noaanlbu varchar(1), batchnum varchar(18), iskoppelnummer varchar(1), withfoto varchar(1), BUSINESS KEY(mandant,haushalt,abinummer,gangnr,nummer))
0:CREATE TABLE historie (mandant varchar(3), haushalt varchar(4), nummer varchar(30), zeitstempel varchar(18), userid varchar(50), text1 varchar(50), text2 varchar(50), BUSINESS KEY (mandant,haushalt,nummer,zeitstempel))
0:CREATE TABLE hisdetail (mandant varchar(3), haushalt varchar(4), nummer varchar(30), zeitstempel varchar(18), lfdnr int, feldname varchar(15), oldvalue varchar(255), newvalue varchar(255), BUSINESS KEY(mandant,haushalt,nummer,zeitstempel,lfdnr))
0:CREATE TABLE layoutdef (mandant varchar(3), haushalt varchar(4), userid varchar(50), layout varchar(8), name varchar(50), pagebreaklevel int, level0 varchar(50), level1 varchar(50), level2 varchar(50), level3 varchar(50), level4 varchar(50), level5 varchar(50), level6 varchar(50), level7 varchar(50), freeitems varchar(255), freeitems2 varchar(255), freeitems3 varchar(255), hisfelder1 varchar(255), hisfelder2 varchar(255), hisfelder3 varchar(255), BUSINESS KEY (mandant, haushalt, userid, layout))
0:CREATE TABLE buchungskreise (mandant varchar(3), buckr varchar(4), bezeichnung varchar(255), barcodehead varchar(255), barcodefoot varchar(255), conname varchar(8), dialogtab varchar(8), importtab varchar(8), exporttab varchar(8), invnumformatclass varchar(255), exportdir varchar(255), autoinvnum int, noanlbu int, etityp varchar(20), etilay varchar(20), invnummervorb varchar(30), bezeichnungGebaeude varchar(50), bezeichnungGebaeude2 varchar(50), bezeichnungEtage varchar(50), bezeichnungEtagen varchar(50), bezeichnungRaum varchar(50), bezeichnungRaeume varchar(50), bezeichnungOrgeinheiten varchar(50), bezeichnungOrgeinheit varchar(50), bezeichnungBereich varchar(50), bezeichnungBereiche varchar(50), BUSINESS KEY(mandant,buckr))
0:CREATE TABLE connections (mandant varchar(3), haushalt varchar(4), name varchar(8), bezeichnung varchar(50), applid varchar(4), type varchar(8), url varchar(255), port int, timeout int, configparams clob(64000), proxyserver varchar(255), clientcertificate varchar(255), clientcertificatepassphrase varchar(255), servercertificate varchar(255), servercertificatepassphrase varchar(255), userid varchar(50), passwd varchar(255), BUSINESS KEY (mandant,haushalt,name))
0:CREATE TABLE abistamm (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), bezeichnung varchar(50), datumstart varchar(8), datumende varchar(8), status int, datumstatus varchar(8), inventurleiter varchar(50), ersterf varchar(1), zyklus varchar(12), BUSINESS KEY(mandant, haushalt, abinummer))
0:CREATE TABLE abibereich (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), bernummer varchar(10), orgeinheit varchar(10), bereich varchar(4), gebaeude varchar(10), etage varchar(4), raum varchar(6), haupttyp varchar(3), untertyp varchar(3), formel varchar(255), BUSINESS KEY(mandant, haushalt, abinummer, bernummer))
0:CREATE TABLE zaehlliste (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), gangnr varchar(3), nummer varchar(30), fremdschluessel varchar(50), bezeichnung varchar(50), sollgebaeude varchar(10), istgebaeude varchar(10), solletage varchar(4), istetage varchar(4), sollraum varchar(6), istraum varchar(6), sollmenge decimal(14,2), istmenge decimal(14,2), einheit varchar(3), userid varchar(50), zeitstempel varchar(18), bemerkung1 varchar(50), bemerkung2 varchar(100), neu varchar(1), withfoto varchar(1), BUSINESS KEY(mandant, haushalt, abinummer, gangnr, nummer))
0:CREATE TABLE raumliste (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), gangnr varchar(3), gebaeude varchar(10), etage varchar(4), raum varchar(6), status int, bemerkung varchar(100), BUSINESS KEY(mandant, haushalt, abinummer, gangnr, gebaeude, etage, raum))
0:CREATE TABLE gangliste (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), gangnr varchar(3), ansager varchar(50), aufschreiber varchar(50), kontrolleur varchar(50), inventurleiter varchar(50), datumstart varchar(8), datumende varchar(8), status int, numvon varchar(30), numbis varchar(30), bemerkung varchar(50), resourceid varchar(8), BUSINESS KEY(mandant, haushalt, abinummer, gangnr))
0:CREATE TABLE ergebnisliste (mandant varchar(3), haushalt varchar(4), abinummer varchar(10), nummer varchar(30), gangnr varchar(3), origbuckr varchar(4), fremdschluessel varchar(50), bezeichnung varchar(50), gebaeude varchar(10), etage varchar(4), raum varchar(6), menge decimal(14,2), einheit varchar(3), userid varchar(50), zeitstempel varchar(18), zaehlbemerkung1 varchar(50), zaehlbemerkung2 varchar(100), raumbemerkung varchar(100), nachbemerkung varchar(100), grundabgang varchar(100), neu varchar(1), chkfertig varchar(1), chkabgang varchar(1), chkignore varchar(1), chkauswahl varchar(1), BUSINESS KEY(mandant, haushalt, abinummer, nummer, gangnr))
0:CREATE TABLE permissions (mandant varchar(3), userid varchar(50), buckr varchar(4), p_online int, p_offline int, p_anl int, p_config int, p_admin int, oe01 varchar(10), oe02 varchar(10), oe03 varchar(10), oe04 varchar(10), oe05 varchar(10), oe06 varchar(10), oe07 varchar(10), oe08 varchar(10), oe09 varchar(10), oe10 varchar(10), be01 varchar(4), be02 varchar(4), be03 varchar(4), be04 varchar(4), be05 varchar(4), be06 varchar(4), be07 varchar(4), be08 varchar(4), be09 varchar(4), be10 varchar(4), BUSINESS KEY(mandant, userid, buckr))
0:CREATE TABLE anltab (mandant varchar(3), haushalt varchar(4), tabname varchar(8), applid varchar(4), applmode varchar(6), bezeichnung varchar(30), version int, BUSINESS KEY(mandant, haushalt, tabname))
0:CREATE TABLE anltabfields (mandant varchar(3), haushalt varchar(4), tabname varchar(8), fieldname varchar(5), bezeichnung varchar(50), datatyp varchar(10), len int, scale int, withthousandseparator int,withleadingzeroes int,blankwhenzeroes int,withsign int,keyformat varchar(12),fillchar varchar(1),alignment varchar(12), dateformat varchar(10), modus varchar(8), kategorie varchar(8), formel varchar(255), werte varchar(255), source varchar(8), updatemode varchar(1), bemerkung varchar(255), BUSINESS KEY(mandant, haushalt, tabname, fieldname))
0:CREATE TABLE etityp (mandant varchar(3), haushalt varchar(4), etityp varchar(20), bezeichnung varchar(30), papierbreite int, papierhoehe int, papierausrichtung varchar(1), papierrandoben int, papierrandunten int, papierrandlinks int, papierrandrechts int, anzahlspalten int, anzahlzeilen int, etikettenzeilenabstand int, etikettenspaltenabstand int, veraenderbar int, BUSINESS KEY (mandant, haushalt, etityp))
0:CREATE TABLE etilay (mandant varchar(3), haushalt varchar(4), etityp varchar(20), etilay varchar(20), bezeichnung varchar(30), invetikett int, anlagenetikett int, raumetikett int, veraenderbar int, ordner varchar(255), dateiname varchar(255), dateiendung varchar(3), BUSINESS KEY (mandant, haushalt, etityp, etilay))
0:CREATE TABLE etipos (mandant varchar(3), haushalt varchar(4), etityp varchar(20), etilay varchar(20), xpos int, ypos int, breite int, ausrichtung int, schrift varchar(30), groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255), BUSINESS KEY (mandant, haushalt, etityp, etilay, xpos, ypos))
0:CREATE TABLE suchfelder (mandant varchar(3), nummer varchar(30), suchfeld1 varchar(255), suchfeld2 varchar(255), suchfeld3 varchar(255), suchfeld4 varchar(255), suchfeld5 varchar(255), suchfeld6 varchar(255), suchfeld7 varchar(255), suchfeld8 varchar(255), suchfeld9 varchar(255), suchfeld10 varchar(255), suchfeld11 varchar(255), suchfeld12 varchar(255), suchfeld13 varchar(255), suchfeld14 varchar(255), suchfeld15 varchar(255), suchfeld16 varchar(255), suchfeld17 varchar(255), suchfeld18 varchar(255), suchfeld19 varchar(255), suchfeld20 varchar(255), suchfeld21 varchar(255), suchfeld22 varchar(255), suchfeld23 varchar(255), suchfeld24 varchar(255), suchfeld25 varchar(255), suchfeld26 varchar(255), suchfeld27 varchar(255), suchfeld28 varchar(255), suchfeld29 varchar(255), suchfeld30 varchar(255), BUSINESS KEY(mandant,nummer))
0:CREATE TABLE inventarfremd (mandant varchar(3), nummer varchar(30), fremdschluessel varchar(50), BUSINESS KEY(mandant,nummer))
0:CREATE TABLE meldeclientconfig (mandant varchar(3), emailadresse varchar(255), smtphost varchar(255), smtpport varchar(5), usessl int, username varchar(255), password varchar(255), emailmessagefield1 varchar(255), emailmessagefield2 varchar(255), emailmessagefield3 varchar(255), emailmessagefield4 varchar(255), emailbetreff varchar(255), meldeclientuser varchar(50), leitfadenlink varchar(255), BUSINESS KEY (mandant))
0:CREATE TABLE journal (mandant varchar(3), haushalt varchar(4), zeitstempel varchar(18), userid varchar(50), tac varchar(12), opc varchar(4), rc int, msg varchar(255), hasdetail varchar(1), BUSINESS KEY(mandant, haushalt, zeitstempel))  
0:CREATE TABLE journaldetail (mandant varchar(3), haushalt varchar(4), zeitstempel varchar(18), lfdnr int, feldname varchar(50), alterwert varchar(255), neuerwert varchar(255), BUSINESS KEY(mandant, haushalt, zeitstempel, lfdnr))
0:CREATE TABLE suchkriterien(mandant varchar(3), buckr varchar(4), userid varchar(50), name varchar(20), suchart varchar(10), zuordnung varchar(10), invnummer varchar(30), fremdschluessel varchar(50), invmuster varchar(30), issuchebez int, issuchebes int, invbez varchar(255), haupttyp varchar(3), untertyp varchar(3), standort1 varchar(10), standort2 varchar(4), standort3 varchar(6), orgeinheit varchar(10), bereich varchar(4), listart varchar(10), kennzdatumvon varchar(3), kennzdatumbis varchar(3), invdatumvon timestamp, invdatumbis timestamp, status varchar(10), freeitemswerte clob(64000), bewegungenwerte clob(64000), BUSINESS KEY(mandant, buckr, userid, name))
0:CREATE TABLE documenttemplate(mandant varchar(3), buckr varchar(4), templateid varchar(36), name varchar(255), description varchar(255), title varchar(255), doctype varchar(10), doccat varchar(10), filename varchar(255), subscribed int, author varchar(50), lastmodifieddate timestamp, filesize int, BUSINESS KEY(mandant, buckr, templateid))
0:CREATE TABLE documenttemplatedata(mandant varchar(3), buckr varchar(4), templateid varchar(36), data blob(67108864), BUSINESS KEY(mandant, buckr, templateid))
0:CREATE TABLE printoptions(mandant varchar(3), buckr varchar(4), userid varchar(50), doccat varchar(10), name varchar(20), sortfields clob(2048), maxgwidx int, nurgefuelltefelder int, mitallghist int, fieldsandhist clob(64000), BUSINESS KEY(mandant, buckr, userid, doccat, name))
0:CREATE TABLE mandanten (mandant varchar(3), bezeichnung varchar(255), beschreibung clob(64000), sperruser varchar(50), sperrtext clob(64000), allowedfilepaths clob(64000), BUSINESS KEY(mandant))
0:CREATE TABLE benutzer (mandant varchar(3), userid varchar(50), passwd varchar(20), pwddate timestamp, faultylogin int, lastlogin timestamp, lastloginok int, name varchar(100), email varchar(100), docpath varchar(255), permissionparent varchar(50), gesperrt int, oldpwd1 varchar(20), oldpwd2 varchar(20), oldpwd3 varchar(20), oldpwd4 varchar(20), oldpwd5 varchar(20), oldpwd6 varchar(20), oldpwd7 varchar(20), oldpwd8 varchar(20), oldpwd9 varchar(20), isinitpwd int, fromldap int, BUSINESS KEY(mandant, userid))
0:CREATE TABLE inventarfoto(mandant varchar(3), haushalt varchar(4), nummer varchar(30), daten blob(10000000), BUSINESS KEY(mandant,haushalt,nummer))
0:CREATE TABLE inventarfototmp(mandant varchar(3), haushalt varchar(4), abinummer varchar(10), gangnr varchar(3), nummer varchar(30), daten blob(10000000), BUSINESS KEY(mandant,haushalt,abinummer,gangnr,nummer))

0:CREATE TABLE batchjob (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, endtime timestamp, owner varchar(50), exitcode varchar(2500), exitmessage varchar(2500), filenameprefix varchar(255), resulttype varchar(255), hasprotocol int, haserror int, BUSINESS KEY(userid,mandant,buckr,jobname,starttime))
0:CREATE TABLE batchjobresult (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, result blob(67108864), protocol blob(67108864), error blob(67108864), BUSINESS KEY(userid,mandant,buckr,jobname,starttime))

0:CREATE INDEX inventar_maninv ON inventar (mandant, nummer)
0:CREATE INDEX inventartmp_maninv ON inventartmp (mandant, nummer)
0:CREATE UNIQUE INDEX inventarfremdkey_idx ON inventarfremd (mandant, fremdschluessel)
0:CREATE INDEX zaehliste_maninv ON zaehlliste (mandant, nummer)
0:CREATE INDEX inventar_zaehl ON inventar (mandant, haushalt, abinummer, gebaeude, etage, raum) 
0:CREATE INDEX idx_hisdetail on hisdetail (mandant,haushalt,nummer,zeitstempel,lfdnr desc)
0:CREATE INDEX idx_history on historie (mandant,haushalt,nummer,zeitstempel desc)
0:CREATE INDEX idx_history_text on historie (mandant,haushalt,nummer,text2)
0:CREATE UNIQUE INDEX idx_documenttemplate_name on documenttemplate (mandant,buckr,name)

0:ORACLE=INSERT INTO benutzer (mandant, userid, passwd, name) VALUES(' ', 'KAI', '5XUCGUHW', 'Administrator')
0:DEFAULT=INSERT INTO benutzer (mandant, userid, passwd, name) VALUES('', 'KAI', '5XUCGUHW', 'Administrator')
0:RESETDEFAULT
0:ORACLE=INSERT INTO permissions (mandant, buckr, userid, p_online, p_offline, p_anl, p_config, p_admin) VALUES(' ', ' ', 'KAI', 4, 2, 4, 1, 2)
0:DEFAULT=INSERT INTO permissions (mandant, buckr, userid, p_online, p_offline, p_anl, p_config, p_admin) VALUES('', '', 'KAI', 4, 2, 4, 1, 2)
0:RESETDEFAULT

0:INSERT INTO btfsystem (dbversion) VALUES(0)

0:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

0:CREATE VIEW standorte_view AS select bk.mandant, bk.buckr, g.gebaeude as standort1, e.etage as standort2, r.raum as standort3 from buchungskreise bk left join gebaeude g on g.mandant=bk.mandant and (g.haushalt=bk.buckr or g.haushalt='0000') left join etagen e on e.mandant=bk.mandant and (e.haushalt=bk.buckr or e.haushalt='0000') and e.gebaeude=g.gebaeude left join raeume r on r.mandant=bk.mandant and (r.haushalt=bk.buckr or r.haushalt='0000') and r.gebaeude=e.gebaeude and r.etage=e.etage
0:CREATE VIEW abiuebersicht_view AS select bk.mandant, bk.buckr, a.abinummer, gl.gangnr, a.zyklus, a.inventurleiter, gl.resourceid, a.status as abistatus, gl.status as gangstatus, rl.gebaeude as standort1, rl.etage as standort2, rl.raum as standort3, rl.status as standortstatus from buchungskreise bk left join abistamm a on a.mandant=bk.mandant and a.haushalt=bk.buckr left join gangliste gl on gl.mandant=bk.mandant and gl.haushalt=bk.buckr and gl.abinummer=a.abinummer left join raumliste rl on rl.mandant=bk.mandant and rl.haushalt=bk.buckr and rl.abinummer=gl.abinummer and rl.gangnr=gl.gangnr

0:SETVERSION=20250411
################################################################################
#
# Kai 01.03 (Update)
#
################################################################################
#
# Version vor 2005-04-14: alle alter-table-Anweisungen der älteren Versionen
#
#Version 1:
20050101:alter table inventar add bereich char(2) default null
#Version 2:
20050101:alter table mengeneinheit change column mengeneinheit einheit char(3)
20050101:alter table inventar change column bezeichnung bezeichnung varchar(50) default null
20050101:alter table freeitemsdef add pflichtfeld boolean
20050101:alter table freeitemsdef change column bezeichnung bezeichnung char(50) default null
#Version 3:
20050101:alter table freeitemsdef change column position position int(3) default null
#Version 4:
20050101:alter table freeitemsdata change lfdnr lfdnr int(3) not null
20050101:alter table inventar drop column abetrie
20050101:alter table inventar drop column asackon
20050101:alter table inventar drop column aident
20050101:alter table inventar drop column pbetrie
20050101:alter table inventar drop column psackon
20050101:alter table inventar drop column pident
20050101:alter table inventar ADD aAnlKey varchar(32) default null
20050101:alter table inventar ADD pAnlKey varchar(32) default null
#Version 5:
20050101:alter table inventar ADD isMuster char(1) default null
20050101:alter table freeitemsdef change column pflichtfeld pflichtfeld int(1)
#Version 6:
20050101:alter table freeitemsdef change column position position int
20050101:alter table historie change column timestamp zeitstempel char(18)
20050101:alter table freeitemsdef change column position pos int
#
# 2005-04-27: neue Tabelle layoutdef
#
20050427:CREATE TABLE layoutdef (userid char(8), layout varchar(8), name varchar(50), pagebreaklevel int, level0 varchar(50), level1 varchar(50), level2 varchar(50), level3 varchar(50), level4 varchar(50), level5 varchar(50), level6 varchar(50), level7 varchar(50), PRIMARY KEY (userid, layout))
20050427:update btfsystem set dbversion=20050427
#
# 2005-05-18: Mandant 4stellig
#
20050518:HSQLDBSQL=ALTER TABLE bereich ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE bereich MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh01 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh01 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh02 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh02 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh03 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh03 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh04 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh04 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh05 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh05 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh06 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh06 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh07 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh07 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh08 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh08 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh09 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh09 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE benutzer ALTER COLUMN hh10 char(4)
20050518:DEFAULT=ALTER TABLE benutzer MODIFY hh10 char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE gebaeude ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE gebaeude MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE etagen ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE etagen MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE raeume ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE raeume MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE freeitemsdef ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE freeitemsdef MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE haupttypen ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE haupttypen MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE untertypen ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE untertypen MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE historie ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE historie MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE mengeneinheit ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE mengeneinheit MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE orgeinheit ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE orgeinheit MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE suchfelddef ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE suchfelddef MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE inventar MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:HSQLDBSQL=ALTER TABLE freeitemsdata ALTER COLUMN haushalt char(4)
20050518:DEFAULT=ALTER TABLE freeitemsdata MODIFY haushalt char(4)
20050518:RESETDEFAULT
20050518:update btfsystem set dbversion=20050518
#
# 2005-06-01: Neue Tabellen für Historie und Mandantenstamm
#
20050601:MYSQL=CREATE TABLE hisdetail (mandant char(3), haushalt char(4), nummer char(10), zeitstempel char(18), lfdnr int, feldname varchar(20), oldvalue varchar(50), newvalue varchar(50), PRIMARY KEY  (mandant,haushalt,nummer,zeitstempel,lfdnr))
20050601:HSQLDBSQL=CREATE CACHED TABLE hisdetail (mandant char(3), haushalt char(4), nummer char(10), zeitstempel char(18), lfdnr int, feldname varchar(20), oldvalue varchar(50), newvalue varchar(50), PRIMARY KEY  (mandant,haushalt,nummer,zeitstempel,lfdnr))
20050601:ACCESS=CREATE TABLE hisdetail (mandant char(3), haushalt char(4), nummer char(10), zeitstempel char(18), lfdnr int, feldname varchar(20), oldvalue varchar(50), newvalue varchar(50), PRIMARY KEY  (mandant,haushalt,nummer,zeitstempel,lfdnr))
20050601:ORACLE=CREATE TABLE hisdetail (mandant char(3), haushalt char(4), nummer char(10), zeitstempel char(18), lfdnr int, feldname varchar(20), oldvalue varchar(50), newvalue varchar(50), PRIMARY KEY  (mandant,haushalt,nummer,zeitstempel,lfdnr))
20050601:RESETDEFAULT
20050601:CREATE TABLE mandanten (mandant char(3), haushalt char(4), bezeichnung varchar(30), barcodehead varchar(25), barcodefoot varchar(25), anlbu varchar(4), albmanhh varchar(10), filter01 varchar(255), filter02 varchar(255), filter03 varchar(255), filter04 varchar(255), filter05 varchar(255), filter06 varchar(255), filter07 varchar(255), filter08 varchar(255), filter09 varchar(255), filter10 varchar(255), PRIMARY KEY  (mandant,haushalt))
20050601:update btfsystem set dbversion=20050601
#
# 2005-06-14: Filter-Columns aus Mandanten-Tabelle löschen, FreeItems im Inventarstamm
#
20050614:ALTER TABLE mandanten DROP COLUMN filter01
20050614:ALTER TABLE mandanten DROP COLUMN filter02
20050614:ALTER TABLE mandanten DROP COLUMN filter03
20050614:ALTER TABLE mandanten DROP COLUMN filter04
20050614:ALTER TABLE mandanten DROP COLUMN filter05
20050614:ALTER TABLE mandanten DROP COLUMN filter06
20050614:ALTER TABLE mandanten DROP COLUMN filter07
20050614:ALTER TABLE mandanten DROP COLUMN filter08
20050614:ALTER TABLE mandanten DROP COLUMN filter09
20050614:ALTER TABLE mandanten DROP COLUMN filter10
20050614:alter table inventar add freeitemsdata1 varchar(255)
20050614:alter table inventar add freeitemsdata2 varchar(255)
20050614:RUN de.hallobtf.Kai.utils.convert.ConvertFreeItems
20050614:DROP TABLE freeitemsdata
20050614:update btfsystem set dbversion=20050614
#
# 2005-06-14: FreeItems im Inventarstamm
#
20050624:ALTER TABLE mandanten ADD licensekey varchar(50)
20050624:RUN de.hallobtf.Kai.utils.convert.AdjustAdministratorProfile
20050624:DELETE FROM benutzer WHERE userid='KAI     '
20050624:INSERT INTO benutzer (userid, passwd, mandant, hh01, name, profil) VALUES('KAI     ', 'KAI     ', '###', '####', 'Administrator', '32112')
20050624:update btfsystem set dbversion=20050624
#
# 2005-06-29: Feldname in HisDetail vergrößert
#
20050629:HSQLDBSQL=ALTER TABLE hisdetail alter column feldname varchar(50)
20050629:DEFAULT=ALTER TABLE hisdetail modify feldname varchar(50)
20050629:RESETDEFAULT
20050629:update btfsystem set dbversion=20050629
#
# 2005-06-30: Tabelle für Verbindungsparameter
#
20050630:CREATE TABLE connections (mandant char(3), name char(8), bezeichnung char(50), applid char(4), type char(8), url varchar(255), port int, timeout int, configparams1 varchar(255), configparams2 varchar(255), configparams3 varchar(255), configparams4 varchar(255), PRIMARY KEY  (mandant,name))
20050630:ALTER TABLE mandanten ADD conname char(8) 
20050630:RUN de.hallobtf.Kai.utils.convert.CryptPasswords
20050630:update btfsystem set dbversion=20050630
#
# 2005-07-14: Gebäude 10Stellig
#
20050714:HSQLDBSQL=ALTER TABLE gebaeude ALTER COLUMN gebaeude char(10)
20050714:DEFAULT=ALTER TABLE gebaeude MODIFY gebaeude char(10)
20050714:RESETDEFAULT
20050714:HSQLDBSQL=ALTER TABLE etagen ALTER COLUMN gebaeude char(10)
20050714:DEFAULT=ALTER TABLE etagen MODIFY gebaeude char(10)
20050714:RESETDEFAULT
20050714:HSQLDBSQL=ALTER TABLE raeume ALTER COLUMN gebaeude char(10)
20050714:DEFAULT=ALTER TABLE raeume MODIFY gebaeude char(10)
20050714:RESETDEFAULT
20050714:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN gebaeude char(10)
20050714:DEFAULT=ALTER TABLE inventar MODIFY gebaeude char(10)
20050714:RESETDEFAULT
20050714:update btfsystem set dbversion=20050714
#
# 2005-07-21: Feldname für Historiendetails 50Stellig
#
20050721:HSQLDBSQL=ALTER TABLE hisdetail ALTER COLUMN feldname varchar(50)
20050721:DEFAULT=ALTER TABLE hisdetail MODIFY feldname varchar(50)
20050721:RESETDEFAULT
20050721:update btfsystem set dbversion=20050721
#
# 2005-07-26: Schlüsselfelder von varchar nach char konvertieren
#
20050726:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN orgeinheit char(4)
20050726:DEFAULT=ALTER TABLE inventar MODIFY orgeinheit char(4)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN nummer char(10)
20050726:DEFAULT=ALTER TABLE inventar MODIFY nummer char(10)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN invMuster char(10)
20050726:DEFAULT=ALTER TABLE inventar MODIFY invMuster char(10)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN datumAbgang char(8)
20050726:DEFAULT=ALTER TABLE inventar MODIFY datumAbgang char(8)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN datumZugang char(8)
20050726:DEFAULT=ALTER TABLE inventar MODIFY datumZugang char(8)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE layoutdef ALTER COLUMN layout char(8)
20050726:DEFAULT=ALTER TABLE layoutdef MODIFY layout char(8)
20050726:RESETDEFAULT
20050726:HSQLDBSQL=ALTER TABLE connections ALTER COLUMN bezeichnung varchar(50)
20050726:DEFAULT=ALTER TABLE connections MODIFY bezeichnung varchar(50)
20050726:RESETDEFAULT
20050726:update btfsystem set dbversion=20050726

################################################################################
#
# Kai 01.04 (Update)
#
################################################################################
#
# 2005-12-19:
#
20051219:ALTER TABLE freeitemsdef DROP COLUMN decimalsign
20051219:ALTER TABLE freeitemsdef ADD numtyp varchar(10)
20051219:ALTER TABLE freeitemsdef ADD suchfeldnr int
20051219:ALTER TABLE freeitemsdef ADD kategorie varchar(8)
20051219:ALTER TABLE freeitemsdef ADD formel varchar(255)
20051219:ALTER TABLE freeitemsdef ADD werte varchar(255)
20051219:ALTER TABLE freeitemsdef ADD aufteilung varchar(20)
20051219:ALTER TABLE freeitemsdef ADD retriever varchar(255)
20051219:ALTER TABLE freeitemsdef ADD musterflag char(1)
20051219:UPDATE freeitemsdef SET kategorie='Manuell', musterflag='W'
20051219:RUN de.hallobtf.Kai.utils.convert.ConvertSuchfeldDef
20051219:DROP TABLE suchfelddef

20051219:ALTER TABLE layoutdef add freeitems varchar(255)

20051219:ALTER TABLE inventar DROP COLUMN isMuster
20051219:ALTER TABLE inventar ADD abinummer char(10)
20051219:ALTER TABLE inventar ADD grundabgang varchar(100)

20051219:HSQLDBSQL=ALTER TABLE mandanten ALTER COLUMN albmanhh varchar(20)
20051219:MSSQL=ALTER TABLE mandanten ALTER COLUMN albmanhh varchar(20)
20051219:DB2=ALTER TABLE mandanten ALTER COLUMN albmanhh SET DATA TYPE varchar(20)
20051219:DEFAULT=ALTER TABLE mandanten MODIFY albmanhh varchar(20)
20051219:RESETDEFAULT

20051219:ALTER TABLE benutzer ADD email varchar(100)

20051219:CREATE TABLE abistamm (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, bezeichnung varchar(50), datumzugang varchar(8), datumstart varchar(8), datumende varchar(8), status int, datumstatus varchar(8), inventurleiter varchar(50), ersterf char(1), PRIMARY KEY (mandant, haushalt, abinummer))
20051219:CREATE TABLE abibereich (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, bernummer varchar(10) not null, orgeinheit char(4), bereich char(2), gebaeude char(10), etage char(2), raum char(4), haupttyp char(3), untertyp char(3), PRIMARY KEY (mandant, haushalt, abinummer, bernummer))
20051219:CREATE TABLE raumliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, gebaeude char(10) not null, etage char(2) not null, raum char(4) not null, status int, bemerkung varchar(100), PRIMARY KEY (mandant, haushalt, abinummer, gangnr, gebaeude, etage, raum))
20051219:CREATE TABLE gangliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, ansager varchar(50), aufschreiber varchar(50), kontrolleur varchar(50), inventurleiter varchar(50), datumstart char(8), datumende char(8), status int, numvon char(10), numbis char(10), resourceid char(8), PRIMARY KEY (mandant, haushalt, abinummer, gangnr))

20051219:HSQLDBSQL=CREATE CACHED TABLE zaehlliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, nummer char(10) not null, bezeichnung varchar(50), sollgebaeude char(10), istgebaeude char(10), solletage char(2), istetage char(2), sollraum char(4), istraum char(4), sollmenge double, istmenge double, einheit char(3), zeitstempel char(18), bemerkung1 varchar(100), bemerkung2 varchar(100), neu char(1), PRIMARY KEY (mandant, haushalt, abinummer, gangnr, nummer))
20051219:ORACLE=CREATE TABLE zaehlliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, nummer char(10) not null, bezeichnung varchar(50), sollgebaeude char(10), istgebaeude char(10), solletage char(2), istetage char(2), sollraum char(4), istraum char(4), sollmenge number(10,2), istmenge number(10,2), einheit char(3), zeitstempel char(18), bemerkung1 varchar(100), bemerkung2 varchar(100), neu char(1), PRIMARY KEY (mandant, haushalt, abinummer, gangnr, nummer))
20051219:MSSQL=CREATE TABLE zaehlliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, nummer char(10) not null, bezeichnung varchar(50), sollgebaeude char(10), istgebaeude char(10), solletage char(2), istetage char(2), sollraum char(4), istraum char(4), sollmenge decimal(10,2), istmenge decimal(10,2), einheit char(3), zeitstempel char(18), bemerkung1 varchar(100), bemerkung2 varchar(100), neu char(1), PRIMARY KEY (mandant, haushalt, abinummer, gangnr, nummer))
20051219:DEFAULT=CREATE TABLE zaehlliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, gangnr char(3) not null, nummer char(10) not null, bezeichnung varchar(50), sollgebaeude char(10), istgebaeude char(10), solletage char(2), istetage char(2), sollraum char(4), istraum char(4), sollmenge double, istmenge double, einheit char(3), zeitstempel char(18), bemerkung1 varchar(100), bemerkung2 varchar(100), neu char(1), PRIMARY KEY (mandant, haushalt, abinummer, gangnr, nummer))
20051219:RESETDEFAULT

20051219:HSQLDBSQL=CREATE CACHED TABLE inventartmp (mandant char(3) not null, haushalt char(4) not null, nummer char(10) not null, haupttyp char(3), untertyp char(3), orgeinheit char(4), bereich char(2), invMuster char(10), bezeichnung varchar(50), beschreibung varchar(255), gebaeude char(10), etage char(2), raum char(4), kzAbgang char(1), datumZugang char(8), datumAbgang char(8), menge double, einheit char(3), suchfeld1 varchar(100), suchfeld2 varchar(100), suchfeld3 varchar(100), suchfeld4 varchar(100), suchfeld5 varchar(100), suchfeld6 varchar(100), freeitemsdata1 varchar(255), freeitemsdata2 varchar(255), grundabgang varchar(100), abinummer char(10), PRIMARY KEY  (mandant,haushalt,nummer))
20051219:ORACLE=CREATE TABLE inventartmp (mandant char(3) not null, haushalt char(4) not null, nummer char(10) not null, haupttyp char(3), untertyp char(3), orgeinheit char(4), bereich char(2), invMuster char(10), bezeichnung varchar(50), beschreibung varchar(255), gebaeude char(10), etage char(2), raum char(4), kzAbgang char(1), datumZugang char(8), datumAbgang char(8), menge number(10,2), einheit char(3), suchfeld1 varchar(100), suchfeld2 varchar(100), suchfeld3 varchar(100), suchfeld4 varchar(100), suchfeld5 varchar(100), suchfeld6 varchar(100), freeitemsdata1 varchar(255), freeitemsdata2 varchar(255), grundabgang varchar(100), abinummer char(10), PRIMARY KEY  (mandant,haushalt,nummer))
20051219:MSSQL=CREATE TABLE inventartmp (mandant char(3) not null, haushalt char(4) not null, nummer char(10) not null, haupttyp char(3), untertyp char(3), orgeinheit char(4), bereich char(2), invMuster char(10), bezeichnung varchar(50), beschreibung varchar(255), gebaeude char(10), etage char(2), raum char(4), kzAbgang char(1), datumZugang char(8), datumAbgang char(8), menge decimal(10,2), einheit char(3), suchfeld1 varchar(100), suchfeld2 varchar(100), suchfeld3 varchar(100), suchfeld4 varchar(100), suchfeld5 varchar(100), suchfeld6 varchar(100), freeitemsdata1 varchar(255), freeitemsdata2 varchar(255), grundabgang varchar(100), abinummer char(10), PRIMARY KEY  (mandant,haushalt,nummer))
20051219:DEFAULT=CREATE TABLE inventartmp (mandant char(3) not null, haushalt char(4) not null, nummer char(10) not null, haupttyp char(3), untertyp char(3), orgeinheit char(4), bereich char(2), invMuster char(10), bezeichnung varchar(50), beschreibung varchar(255), gebaeude char(10), etage char(2), raum char(4), kzAbgang char(1), datumZugang char(8), datumAbgang char(8), menge double, einheit char(3), suchfeld1 varchar(100), suchfeld2 varchar(100), suchfeld3 varchar(100), suchfeld4 varchar(100), suchfeld5 varchar(100), suchfeld6 varchar(100), freeitemsdata1 varchar(255), freeitemsdata2 varchar(255), grundabgang varchar(100), abinummer char(10), PRIMARY KEY  (mandant,haushalt,nummer))
20051219:RESETDEFAULT

20051219:DB2=CREATE UNIQUE INDEX abistamm_idx ON abistamm (mandant, haushalt, abinummer)
20051219:DB2=CREATE UNIQUE INDEX abibereich_idx ON abibereich (mandant, haushalt, abinummer, bernummer)
20051219:DB2=CREATE UNIQUE INDEX raumliste_idx ON raumliste (mandant, haushalt, abinummer, gangnr, gebaeude, etage, raum)
20051219:DB2=CREATE UNIQUE INDEX gangliste_idx ON gangliste (mandant, haushalt, abinummer, gangnr)
20051219:DB2=CREATE UNIQUE INDEX zaehlliste_idx ON zaehlliste (mandant, haushalt, abinummer, gangnr, nummer)
20051219:DB2=CREATE UNIQUE INDEX inventartmp_idx ON inventartmp (mandant,haushalt,nummer)

20051219:ALTER TABLE btfsystem add resourceid varchar(8)
20051219:update btfsystem set dbversion=20051219

#
# 2005-12-28: Ergebnisliste für Inventur-Nachbearbeitung
#
20051228:HSQLDBSQL=CREATE CACHED TABLE ergebnisliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, nummer char(10) not null, gangnr char(3) not null, bezeichnung varchar(50), gebaeude char(10), etage char(2), raum char(4), menge double, einheit char(3), userid char(8), zeitstempel char(18), zaehlbemerkung1 varchar(100), zaehlbemerkung2 varchar(100), raumbemerkung varchar(100), neu char(1), chkstandort char(1), chkmenge char(1), chkfertig char(1), PRIMARY KEY (mandant, haushalt, abinummer, nummer, gangnr))
20051228:ORACLE=CREATE TABLE ergebnisliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, nummer char(10) not null, gangnr char(3) not null, bezeichnung varchar(50), gebaeude char(10), etage char(2), raum char(4), menge number(10,2), einheit char(3), userid char(8), zeitstempel char(18), zaehlbemerkung1 varchar(100), zaehlbemerkung2 varchar(100), raumbemerkung varchar(100), neu char(1), chkstandort char(1), chkmenge char(1), chkfertig char(1), PRIMARY KEY (mandant, haushalt, abinummer, nummer, gangnr))
20051228:MSSQL=CREATE TABLE ergebnisliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, nummer char(10) not null, gangnr char(3) not null, bezeichnung varchar(50), gebaeude char(10), etage char(2), raum char(4), menge decimal(10,2), einheit char(3), userid char(8), zeitstempel char(18), zaehlbemerkung1 varchar(100), zaehlbemerkung2 varchar(100), raumbemerkung varchar(100), neu char(1), chkstandort char(1), chkmenge char(1), chkfertig char(1), PRIMARY KEY (mandant, haushalt, abinummer, nummer, gangnr))
20051228:DEFAULT=CREATE TABLE ergebnisliste (mandant char(3) not null, haushalt char(4) not null, abinummer char(10) not null, nummer char(10) not null, gangnr char(3) not null, bezeichnung varchar(50), gebaeude char(10), etage char(2), raum char(4), menge double, einheit char(3), userid char(8), zeitstempel char(18), zaehlbemerkung1 varchar(100), zaehlbemerkung2 varchar(100), raumbemerkung varchar(100), neu char(1), chkstandort char(1), chkmenge char(1), chkfertig char(1), PRIMARY KEY (mandant, haushalt, abinummer, nummer, gangnr))
20051228:RESETDEFAULT
20051228:DB2=CREATE UNIQUE INDEX ergebnisliste_idx ON ergebnisliste (mandant, haushalt, abinummer, nummer, gangnr)
20051228:RESETDEFAULT
20051228:update btfsystem set dbversion=20051228
#
# 2006-01-06: Zaehlliste mit UserID
#
20060106:ALTER TABLE zaehlliste ADD userid char(8)
20060106:update btfsystem set dbversion=20060106
#
# 2006-01-07: Ergebnisliste mit Abgangskennzeichen
#
20060107:ALTER TABLE ergebnisliste ADD chkabgang char(1)
20060107:update btfsystem set dbversion=20060107
#
# 2006-01-11: Ergebnisliste mit Ignore-Kennzeichen, Historien-Kommentar erweitert.
#
20060111:ALTER TABLE ergebnisliste ADD chkignore char(1)
20060111:HSQLDBSQL=ALTER TABLE historie ALTER COLUMN text1 varchar(50)
20060111:MSSQL=ALTER TABLE historie ALTER COLUMN text1 varchar(50)
20060111:DB2=ALTER TABLE historie ALTER COLUMN text1 SET DATA TYPE varchar(50)
20060111:DEFAULT=ALTER TABLE historie MODIFY text1 varchar(50)
20060111:RESETDEFAULT
20060111:HSQLDBSQL=ALTER TABLE historie ALTER COLUMN text2 varchar(50)
20060111:MSSQL=ALTER TABLE historie ALTER COLUMN text2 varchar(50)
20060111:DB2=ALTER TABLE historie ALTER COLUMN text2 SET DATA TYPE varchar(50)
20060111:DEFAULT=ALTER TABLE historie MODIFY text2 varchar(50)
20060111:RESETDEFAULT
20060111:RUN de.hallobtf.Kai.utils.convert.ConvertZaehlliste
20060111:update btfsystem set dbversion=20060111
################################################################################
#
# Kai 01.05 (Update)
#
################################################################################
#
# 2006-03-29: 
#
20060329:MSSQL=SET ANSI_WARNINGS OFF
20060329:ALTER TABLE layoutdef add mandant char(3)
20060329:ALTER TABLE layoutdef add haushalt char(4)
20060329:ALTER TABLE layoutdef add freeitems2 varchar(255)
20060329:ALTER TABLE layoutdef add freeitems3 varchar(255)
20060329:ALTER TABLE layoutdef add hisfelder1 varchar(255)
20060329:ALTER TABLE layoutdef add hisfelder2 varchar(255)
20060329:ALTER TABLE layoutdef add hisfelder3 varchar(255)

20060329:MYSQL=UPDATE hisdetail set feldname=substring(feldname, 1, 15)
20060329:DEFAULT=NOOPERATION
20060329:RESETDEFAULT

20060329:HSQLDBSQL=ALTER TABLE hisdetail ALTER COLUMN feldname varchar(15)
20060329:MSSQL=ALTER TABLE hisdetail ALTER COLUMN feldname varchar(15)
20060329:DB2=ALTER TABLE hisdetail ALTER COLUMN feldname SET DATA TYPE varchar(15)
20060329:DEFAULT=ALTER TABLE hisdetail MODIFY feldname varchar(15)
20060329:RESETDEFAULT

20060329:ALTER TABLE inventar add noaanlbu char(1)
20060329:ALTER TABLE inventar add nopanlbu char(1)
20060329:ALTER TABLE inventar add aapplid char(4)
20060329:ALTER TABLE inventar add aanlbu01 varchar(20)
20060329:ALTER TABLE inventar add aanlbu02 varchar(20)
20060329:ALTER TABLE inventar add papplid char(4)
20060329:ALTER TABLE inventar add panlbu01 varchar(20)
20060329:ALTER TABLE inventar add panlbu02 varchar(20)
20060329:RUN de.hallobtf.Kai.utils.convert.ConvertInventarAnlbu
20060329:ALTER TABLE inventar drop column hasactive
20060329:ALTER TABLE inventar drop column aAnlKey
20060329:ALTER TABLE inventar drop column haspassiv
20060329:ALTER TABLE inventar drop column pAnlKey

20060329:ALTER TABLE inventartmp add noaanlbu char(1)
20060329:ALTER TABLE inventartmp add nopanlbu char(1)
20060329:ALTER TABLE inventartmp add aapplid char(4)
20060329:ALTER TABLE inventartmp add papplid char(4)
20060329:ALTER TABLE inventartmp add aanlbu01 varchar(20)
20060329:ALTER TABLE inventartmp add aanlbu02 varchar(20)
20060329:ALTER TABLE inventartmp add panlbu01 varchar(20)
20060329:ALTER TABLE inventartmp add panlbu02 varchar(20)
20060329:ALTER TABLE inventartmp drop column hasactive
20060329:ALTER TABLE inventartmp drop column aAnlKey
20060329:ALTER TABLE inventartmp drop column haspassiv
20060329:ALTER TABLE inventartmp drop column pAnlKey

20060329:RUN de.hallobtf.Kai.utils.convert.ConvertEtageRaum

20060329:CREATE TABLE permissions (userid char(8) not null, mandant char(3) not null, buckr char(4) not null, p_online int, p_offline int, p_anl int, p_config int, p_admin int, oe01 char(4), oe02 char(4), oe03 char(4), oe04 char(4), oe05 char(4), oe06 char(4), oe07 char(4), oe08 char(4), oe09 char(4), oe10 char(4), PRIMARY KEY (userid, mandant, buckr))
20060329:RUN de.hallobtf.Kai.utils.convert.SetPermissions
20060329:ALTER TABLE benutzer DROP COLUMN mandant
20060329:ALTER TABLE benutzer DROP COLUMN hh01
20060329:ALTER TABLE benutzer DROP COLUMN hh02
20060329:ALTER TABLE benutzer DROP COLUMN hh03
20060329:ALTER TABLE benutzer DROP COLUMN hh04
20060329:ALTER TABLE benutzer DROP COLUMN hh05
20060329:ALTER TABLE benutzer DROP COLUMN hh06
20060329:ALTER TABLE benutzer DROP COLUMN hh07
20060329:ALTER TABLE benutzer DROP COLUMN hh08
20060329:ALTER TABLE benutzer DROP COLUMN hh09
20060329:ALTER TABLE benutzer DROP COLUMN hh10
20060329:ALTER TABLE benutzer DROP COLUMN profil

20060329:RUN de.hallobtf.Kai.utils.convert.ConvertInventarNummer

20060329:DB2=CREATE UNIQUE INDEX etagen_idx ON etagen (mandant,haushalt,gebaeude,etage)
20060329:DB2=CREATE UNIQUE INDEX raeume_idx ON raeume (mandant,haushalt,gebaeude,etage,raum)
20060329:DB2=CREATE UNIQUE INDEX inventar_idx ON inventar (mandant,haushalt,nummer)
20060329:DB2=CREATE UNIQUE INDEX inventartmp_idx ON inventartmp (mandant,haushalt,nummer)
20060329:DB2=CREATE UNIQUE INDEX historie_idx ON historie (mandant,haushalt,nummer,zeitstempel)
20060329:DB2=CREATE UNIQUE INDEX hisdetail_idx ON hisdetail (mandant,haushalt,nummer,zeitstempel,lfdnr)
20060329:DB2=CREATE UNIQUE INDEX abibereich_idx ON abibereich (mandant, haushalt, abinummer, bernummer)
20060329:DB2=CREATE UNIQUE INDEX zaehlliste_idx ON zaehlliste (mandant, haushalt, abinummer, gangnr, nummer)
20060329:DB2=CREATE UNIQUE INDEX raumliste_idx ON raumliste (mandant, haushalt, abinummer, gangnr, gebaeude, etage, raum)
20060329:DB2=CREATE UNIQUE INDEX gangliste_idx ON gangliste (mandant, haushalt, abinummer, gangnr)
20060329:DB2=CREATE UNIQUE INDEX ergebnisliste_idx ON ergebnisliste (mandant, haushalt, abinummer, nummer, gangnr)
20060329:DB2=CREATE UNIQUE INDEX permissions_idx ON permissions (userid, mandant, buckr)
20060329:RESETDEFAULT

20060329:ALTER TABLE mandanten ADD invnumformatclass varchar(255)
20060329:update btfsystem set dbversion=20060329

#
# 2006-05-14: Berechtigungen für Kai neu anlegen
#
20060514:DELETE FROM benutzer where userid='KAI'
20060514:DELETE FROM permissions where userid='KAI'
20060514:INSERT INTO benutzer (userid, passwd, name) VALUES('KAI     ', '5XUCGUHW', 'Administrator')
20060514:INSERT INTO permissions (userid, mandant, buckr, p_online, p_offline, p_anl, p_config, p_admin) VALUES('KAI     ', '   ', '    ', 3, 2, 1, 1, 1)
20060514:update btfsystem set dbversion=20060514

#
# 2006-05-18: Gänge fertigmelden, wenn Inventur beendet.
#
20060518:RUN de.hallobtf.Kai.utils.convert.SetGangFertig
20060518:update btfsystem set dbversion=20060518

#
# 2006-05-31: Freifelder: externe Datenquelle umbenannt (Standort(Test)->Standort)
#
20060531:update freeitemsdef set retriever='Standorte' where retriever='Standorte(Test)'
20060531:update btfsystem set dbversion=20060531

#
# 2006-06-09: Speichermenge für Freifelddaten erweitert.
#
20060609:ALTER TABLE inventar add freeitemsdata3 varchar(255)
20060609:ALTER TABLE inventar add freeitemsdata4 varchar(255)
20060609:ALTER TABLE inventartmp add freeitemsdata3 varchar(255)
20060609:ALTER TABLE inventartmp add freeitemsdata4 varchar(255)
20060609:update btfsystem set dbversion=20060609
#
# 2006-09-11: Inventarnummern-Format initialisieren (9Stellig + Prüfziffer)
#
20060911:update mandanten set invnumformatclass='de.hallobtf.Kai.formatter.StandardPattern' where haushalt<>'    '
20060911:update mandanten set invnumformatclass='de.hallobtf.Kai.formatter.AlphaNumericPattern10' where haushalt='0000'
20060911:update btfsystem set dbversion=20060911

################################################################################
#
# Kai 01.06 (Update)
#
################################################################################
#
# 2007-01-30:
#
20070130:CREATE TABLE anltab (mandant char(3) not null, haushalt char(4) not null, tabname char(8) not null, applid char(4), applmode char(6), bezeichnung varchar(30), version int, PRIMARY KEY (mandant, haushalt, tabname))
20070130:CREATE TABLE anltabfields (mandant char(3) not null, haushalt char(4) not null, tabname char(8) not null, fieldname char(5) not null, bezeichnung varchar(50), datatyp char(10), len int, scale int, withthousandseparator int,withleadingzeroes int,blankwhenzeroes int,keyformat char(12),fillchar char(1),alignment char(12), dateformat char(12), modus char(8), kategorie char(8), formel varchar(255), werte varchar(255), PRIMARY KEY (mandant, haushalt, tabname, fieldname))

20070130:ALTER TABLE mandanten drop column licensekey
#20070130:ALTER TABLE mandanten drop column invnumformatpattern
20070130:ALTER TABLE mandanten add dialogtab char(8)
20070130:ALTER TABLE mandanten add exporttab char(8)
20070130:ALTER TABLE mandanten add exportdir varchar(255)

20070130:ALTER TABLE inventar add anlkey varchar(40)
20070130:ALTER TABLE inventar add batchnum varchar(18) default ''
20070130:RUN de.hallobtf.Kai.utils.convert.ConvertAnlKey
20070130:ALTER TABLE mandanten drop column albmanhh

20070130:ALTER TABLE inventar drop column aanlbu01
20070130:ALTER TABLE inventar drop column aanlbu02
20070130:ALTER TABLE inventar drop column papplid
20070130:ALTER TABLE inventar drop column panlbu01
20070130:ALTER TABLE inventar drop column panlbu02
20070130:ALTER TABLE inventar drop column nopanlbu

20070130:ALTER TABLE inventartmp add anlkey varchar(40)
20070130:ALTER TABLE inventartmp add batchnum varchar(18) default ''
20070130:ALTER TABLE inventartmp drop column aanlbu01
20070130:ALTER TABLE inventartmp drop column aanlbu02
20070130:ALTER TABLE inventartmp drop column papplid
20070130:ALTER TABLE inventartmp drop column panlbu01
20070130:ALTER TABLE inventartmp drop column panlbu02
20070130:ALTER TABLE inventartmp drop column nopanlbu

20070130:ALTER TABLE inventar add freeitemsdata5 varchar(255)
20070130:ALTER TABLE inventar add freeitemsdata6 varchar(255)
20070130:ALTER TABLE inventartmp add freeitemsdata5 varchar(255)
20070130:ALTER TABLE inventartmp add freeitemsdata6 varchar(255)

20070130:RUN de.hallobtf.Kai.utils.convert.CreateHistoryIndex

20070130:CREATE TABLE rubrik (mandant char(3) not null, haushalt char(4) not null, rubrik char(8) not null, bezeichnung char(50), sichtbar char(1), pos int, PRIMARY KEY  (mandant,haushalt,rubrik))
20070130:DB2=CREATE UNIQUE INDEX rubrik_idx ON (mandant,haushalt,rubrik))
20070130:RESETDEFAULT
20070130:ALTER TABLE freeitemsdef add rubrik char(8)
20070130:RUN de.hallobtf.Kai.utils.convert.ConvertTabs2Rubriken

20070130:update permissions set p_anl=4 where p_anl=1

20070130:update btfsystem set dbversion=20070130

#
# 2007-10-01: Freifeld-Attribute erweitert
#
20071001:ALTER TABLE freeitemsdef drop column tabnr
20071001:ALTER TABLE freeitemsdef add laptoppflichtfeld int default 0
20071001:ALTER TABLE freeitemsdef add laptopsyncfeld int default 1
20071001:ALTER TABLE freeitemsdef add withthousandseparator int default 1
20071001:ALTER TABLE freeitemsdef add withleadingzeroes int default 0
20071001:ALTER TABLE freeitemsdef add blankwhenzeroes int default 0
20071001:ALTER TABLE freeitemsdef add keyformat char(1) default ''
20071001:ALTER TABLE freeitemsdef add fillchar char(1) default ''
20071001:ALTER TABLE freeitemsdef add alignment char(12) default ''
20071001:update btfsystem set dbversion=20071001
20071001:RUN de.hallobtf.Kai.utils.convert.ConvertFidPflichtFelder

#
# 2007-10-02: Datentyp länger
#
20071002:HSQLDBSQL=ALTER TABLE freeitemsdef ALTER COLUMN datatyp char(10)
20071002:MSSQL=ALTER TABLE freeitemsdef ALTER COLUMN datatyp char(10)
20071002:DB2=ALTER TABLE freeitemsdef ALTER COLUMN datatyp SET DATA TYPE char(10)
20071002:DERBY=NOOPERATION
20071002:DEFAULT=ALTER TABLE freeitemsdef MODIFY datatyp char(10)
20071002:RESETDEFAULT
20071002:update btfsystem set dbversion=20071002

#
# 2007-10-03: KeyFormat länger
#
20071003:HSQLDBSQL=ALTER TABLE freeitemsdef ALTER COLUMN keyformat char(12)
20071003:MSSQL=ALTER TABLE freeitemsdef ALTER COLUMN keyformat char(12)
20071003:DB2=ALTER TABLE freeitemsdef ALTER COLUMN keyformat SET DATA TYPE char(12)
20071003:DERBY=NOOPERATION
20071003:DEFAULT=ALTER TABLE freeitemsdef MODIFY keyformat char(12)
20071003:RESETDEFAULT
20071003:update btfsystem set dbversion=20071003

#
# 2007-10-06: 
#
20071006:update inventar set kzAbgang='X' where kzAbgang='A'
20071006:ALTER TABLE mandanten add extinherit int default 0
20071006:RUN de.hallobtf.Kai.utils.convert.InitInheritance
20071006:RUN de.hallobtf.Kai.utils.convert.ReorgStammdaten
20071006:update btfsystem set dbversion=20071006

#
# 2007-11-07: Layout-Kombinationstypen entfernen
#
20071107:RUN de.hallobtf.Kai.utils.convert.DeleteLayoutCombinations
20071107:update btfsystem set dbversion=20071107

#
# 2007-11-12: Abgangskennzeichen in der Historie umstellen
#
20071112:update hisdetail set newvalue='X' where feldname='kzAbgang' and newvalue='A'
20071112:update hisdetail set oldvalue='X' where feldname='kzAbgang' and oldvalue='A'
20071112:update btfsystem set dbversion=20071112

#
# 2007-11-14: Abgangskennzeichen in der Historie umstellen
#
20071114:ALTER TABLE mandanten add autoinvnum int default 1
20071114:RUN de.hallobtf.Kai.utils.convert.InitAutoInvNum
20071114:update btfsystem set dbversion=20071114

#
# 2007-12-13: Fremdschlüssel (FMTools) 
#
20071213:ALTER TABLE inventar add fremdschluessel varchar(50)
20071213:ALTER TABLE inventartmp add fremdschluessel varchar(50)
20071213:ALTER TABLE gebaeude add fremdschluessel varchar(50)
20071213:ALTER TABLE etagen add fremdschluessel varchar(50)
20071213:ALTER TABLE raeume add fremdschluessel varchar(50)
20071213:ALTER TABLE haupttypen add fremdschluessel varchar(50)
20071213:ALTER TABLE untertypen add fremdschluessel varchar(50)
20071213:ALTER TABLE freeitemsdef add fremdschluessel varchar(50)
20071213:ALTER TABLE orgeinheit add fremdschluessel varchar(50)
20071213:ALTER TABLE bereich add fremdschluessel varchar(50)
20071213:update btfsystem set dbversion=20071213
#
# 2007-12-21: External Application im Mandanten 
#
20071221:ALTER TABLE mandanten add extAppl char(8)
20071221:ALTER TABLE mandanten add extApplKey varchar(20)
20071221:update btfsystem set dbversion=20071221
#
# 2008-01-30: KeyFormat länger
#
20080130:HSQLDBSQL=ALTER TABLE freeitemsdef ALTER COLUMN keyformat char(12)
20080130:MSSQL=ALTER TABLE freeitemsdef ALTER COLUMN keyformat char(12)
20080130:DB2=ALTER TABLE freeitemsdef ALTER COLUMN keyformat SET DATA TYPE char(12)
20080130:DERBY=NOOPERATION
20080130:DEFAULT=ALTER TABLE freeitemsdef MODIFY keyformat char(12)
20080130:RESETDEFAULT
20080130:HSQLDBSQL=ALTER TABLE anltabfields ALTER COLUMN keyformat char(12)
20080130:MSSQL=ALTER TABLE anltabfields ALTER COLUMN keyformat char(12)
20080130:DB2=ALTER TABLE anltabfields ALTER COLUMN keyformat SET DATA TYPE char(12)
20080130:DERBY=NOOPERATION
20080130:DEFAULT=ALTER TABLE anltabfields MODIFY keyformat char(12)
20080130:RESETDEFAULT
20080130:update btfsystem set dbversion=20080130

#
# 2008-02-11: Historien-Details löschen, wenn Inventar neu angelegt
#
20080211:update historie set text2='                                                  ' where text1 like 'Inventargut angelegt%'
#20080211:RUN de.hallobtf.Kai.utils.convert.DeleteHisDetails
20080211:update btfsystem set dbversion=20080211

#
# 2008-04-01: Kennzeichen für Koppelnummer
#
20080401:ALTER TABLE inventar add iskoppelnummer char(1) default ' '
20080401:ALTER TABLE inventartmp add iskoppelnummer char(1) default ' '
20080401:update btfsystem set dbversion=20080401

#
# 2008-04-07: Kennzeichen für alte AnlagenID
#
20080407:ALTER TABLE mandanten add oldApplId char(4)
20080407:update btfsystem set dbversion=20080407

#
# 2008-04-08: Kennzeichen für alte AnlagenID wieder entfernen
#
20080408:ALTER TABLE mandanten DROP COLUMN oldApplId
20080408:update btfsystem set dbversion=20080408
#
# 2008-05-03: Konvertierung für Derby
#
20080503:RUN de.hallobtf.Kai.utils.convert.Convert4Derby
20080503:update btfsystem set dbversion=20080503

#
# 2008-06-10: Abgangskennzeichen jetzt wieder mit A statt X
#
20080610:update inventar set kzAbgang='A' where kzAbgang='X'
20080610:update hisdetail set newvalue='A' where feldname='kzAbgang' and newvalue='X'
20080610:update hisdetail set oldvalue='A' where feldname='kzAbgang' and oldvalue='X'
20080610:update btfsystem set dbversion=20080610

#
# 2008-06-13: Extern Inventar Untertyp entfernt
#
20080613:UPDATE freeitemsdef SET kategorie='Manuell ', len=36, retriever='                                                  ', withthousandseparator=0, datatyp='Text      ' where kategorie='Extern  ' and len=0 and retriever='Inventar (Typ/U-Typ)                              ' and withthousandseparator=1 and datatyp='          '     
20080613:update btfsystem set dbversion=20080613

#
# 2008-06-18: Extern Inventar Standorte entfernt
#
20080618:UPDATE freeitemsdef SET kategorie='Manuell ', len=20, retriever='                                                  ', withthousandseparator=0, datatyp='Text      ' where kategorie='Extern  ' and len=0 and retriever='Standorte                                         ' and withthousandseparator=1 and datatyp='          '     
20080618:update btfsystem set dbversion=20080618

#
# 2008-06-19: Doppelte Freifelder mit unterschiedlicher Definition feststellen
#
20080619:RUN de.hallobtf.Kai.utils.convert.CheckDuplicateFreeItems
20080619:update btfsystem set dbversion=20080619
#
# 2008-06-28: Doppelte Inventarnummern feststellen
#
20080628:RUN de.hallobtf.Kai.utils.convert.CheckDuplicateInventar
20080628:update btfsystem set dbversion=20080628

#
# 2008-08-01: Indizes für schnellere Synchronisierung
#
20080801:RUN de.hallobtf.Kai.utils.convert.CreateInventurIndex
20080801:update btfsystem set dbversion=20080801

#
# 2008-08-26: Falls keine Standard-Inventarnummernformat definiert:
#
20080826:RUN de.hallobtf.Kai.utils.convert.SetStandardFormatterClass
20080826:update btfsystem set dbversion=20080826

#
# 2008-11-18: Neues Feld Source für Anlagen-Felder
#
20081118:ALTER TABLE anltabfields add source char(8)
20081118:update btfsystem set dbversion=20081118

#
# 2008-11-20: LayoutDef mit Schlüssel userId, layout, mandant
#
20081120:RUN de.hallobtf.Kai.utils.convert.ExtendLayoutDefPKey
20081120:update btfsystem set dbversion=20081120

#
# 2008-12-11: Unnötige Historieneinträge löschen
#
#20081211:RUN de.hallobtf.Kai.utils.convert.ReorgMusterHistorie
#20081211:update btfsystem set dbversion=20081211

#
# 2008-12-15: Kirp-Strukturnummer 8S auf 007 hochsetzen
#
20081215:RUN de.hallobtf.Kai.utils.convert.UpdateKirpStrukturnummer
20081215:update btfsystem set dbversion=20081215


################################################################################
#
# Kai 02.01 (Update)
#
################################################################################
#
# 2009-06-01: 
#
20090601:CREATE TABLE anltabfieldext (mandant char(3) not null, haushalt char(4) not null, tabname char(8) not null, fieldname char(5) not null, bemerkung varchar(255), PRIMARY KEY  (mandant, haushalt, tabname, fieldname))
20090601:CREATE TABLE bewcolvalue (mandant char(3) not null, haushalt char(4) not null, rubrik char(8) not null, nummer char(30) not null, lfdnr int not null, name char(8) not null, value varchar(255), PRIMARY KEY (mandant, haushalt, nummer, rubrik, lfdnr, name))
20090601:CREATE TABLE bewegungen (mandant char(3) not null, haushalt char(4) not null, nummer char(30) not null, rubrik char(8) not null, lfdnr int not null, PRIMARY KEY  (mandant,haushalt,nummer,rubrik,lfdnr))
20090601:CREATE TABLE freeitemsext (mandant char(3) not null, haushalt char(4) not null, haupttyp char(3) not null, untertyp char(3) not null, name char(8) not null, bemerkung varchar(255), PRIMARY KEY  (mandant,haushalt,haupttyp,untertyp,name))
20090601:CREATE TABLE sperre (mandant char(3) not null, userid char(8) not null, PRIMARY KEY  (mandant))
20090601:CREATE TABLE stapel (mandant char(3) not null, haushalt char(4) not null, userid char(8) not null, nummer char(30) not null, PRIMARY KEY (mandant,haushalt,userid,nummer))
20090601:CREATE TABLE tabellen (mandant char(3) not null, haushalt char(4) not null, key1 char(50) not null, key2 char(50) not null, key3 char(50) not null, key4 char(50) not null, key5 char(50) not null, key6 char(50) not null, daten char(50) not null, PRIMARY KEY (mandant, haushalt, key1, key2, key3, key4, key5, key6))

20090601:DB2=CREATE UNIQUE INDEX anltabfieldext_idx ON anltabfieldext (mandant,haushalt,tabname,fieldname)
20090601:DB2=CREATE UNIQUE INDEX bewcolvalue_idx ON bewcolvalue (mandant,haushalt,nummer,rubrik,lfdnr,name)
20090601:DB2=CREATE UNIQUE INDEX bewegungen_idx ON bewegungen (mandant,haushalt,nummer,rubrik,lfdnr)
20090601:DB2=CREATE UNIQUE INDEX freeitemsext_idx ON freeitemsext (mandant,haushalt,haupttyp,untertyp,name)
20090601:DB2=CREATE UNIQUE INDEX stapel_idx ON stapel (mandant, haushalt, userid, nummer)
20090601:DB2=CREATE UNIQUE INDEX tabellen_idx ON tabellen (mandant, haushalt, key1, key2, key3, key4, key5, key6)
20090601:RESETDEFAULT

20090601:ALTER TABLE rubrik add bewegung int default 0 not null
20090601:ALTER TABLE rubrik add aenderbar int default 1 not null
20090601:ALTER TABLE gangliste ADD bemerkung varchar(50)
20090601:ALTER TABLE freeitemsdef add laptoplistfeld int default 0 not null
20090601:ALTER TABLE mandanten ADD invnummervorb char(30)
20090601:ALTER TABLE mandanten ADD barcodelayout varchar(20)
20090601:DELETE FROM inventartmp WHERE NOT EXISTS (SELECT 1 FROM  zaehlliste where inventartmp.mandant = zaehlliste.mandant AND inventartmp.haushalt = zaehlliste.haushalt AND inventartmp.nummer = zaehlliste.nummer)
20090601:RUN de.hallobtf.Kai.utils.convert.ConvertInventarTmp
20090601:RUN de.hallobtf.Kai.utils.convert.ShrinkZaehlBemerkung
20090601:RUN de.hallobtf.Kai.utils.convert.ConvertErgebnisListe
20090601:ALTER TABLE benutzer add pwddate char(8)
20090601:ALTER TABLE benutzer add faultylogin int
20090601:ALTER TABLE benutzer add lastlogin char(18)
20090601:ALTER TABLE benutzer add lastloginok int
20090601:UPDATE freeitemsdef set withleadingzeroes=1 where datatyp='Schl�ssel'
20090601:UPDATE permissions set p_admin=1 where p_admin>1
20090601:UPDATE permissions set p_online=4 where p_online=3 and p_admin=1
20090601:UPDATE freeitemsdef set datatyp='Text      ', len=50, kategorie='Manuell ' where kategorie='Extern  '
20090607:CREATE TABLE btfparameter (applid char(4) not null, propname char(50) not null, proplabel char(50) not null, propvalue varchar(255) not null, defaultvalue varchar(255) not null, proptype char(8) not null, proplen int not null, PRIMARY KEY  (applid, propname))
20090608:update mandanten set invnumformatclass='de.hallobtf.Kai.formatter.NumericPattern10' where invnumformatclass like 'de.hallobtf.Kai.formatter.NumericPattern%'
#20090609:RUN de.hallobtf.Kai.utils.convert.InitSystemParameter

20090610:HSQLDBSQL=ALTER TABLE orgeinheit ALTER COLUMN orgeinheit char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE orgeinheit ALTER COLUMN orgeinheit SET DATA TYPE char(10)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE orgeinheit')
20090610:POSTGRESQL=ALTER TABLE orgeinheit ALTER COLUMN orgeinheit TYPE char(10)
20090610:DEFAULT=ALTER TABLE orgeinheit MODIFY orgeinheit char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE bereich ALTER COLUMN orgeinheit char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE bereich ALTER COLUMN orgeinheit SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE bereich ALTER COLUMN orgeinheit TYPE char(10)
20090610:DEFAULT=ALTER TABLE bereich MODIFY orgeinheit char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN orgeinheit char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE inventar ALTER COLUMN orgeinheit SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE inventar ALTER COLUMN orgeinheit TYPE char(10)
20090610:DEFAULT=ALTER TABLE inventar MODIFY orgeinheit char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE inventartmp ALTER COLUMN orgeinheit char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE inventartmp ALTER COLUMN orgeinheit SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE inventartmp ALTER COLUMN orgeinheit TYPE char(10)
20090610:DEFAULT=ALTER TABLE inventartmp MODIFY orgeinheit char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE abibereich ALTER COLUMN orgeinheit char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE abibereich ALTER COLUMN orgeinheit SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE abibereich ALTER COLUMN orgeinheit TYPE char(10)
20090610:DEFAULT=ALTER TABLE abibereich MODIFY orgeinheit char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE bereich ALTER COLUMN bereich char(4)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE bereich ALTER COLUMN bereich SET DATA TYPE char(4)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE bereich')
20090610:POSTGRESQL=ALTER TABLE bereich ALTER COLUMN bereich TYPE char(4)
20090610:DEFAULT=ALTER TABLE bereich MODIFY bereich char(4)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE inventar ALTER COLUMN bereich char(4)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE inventar ALTER COLUMN bereich SET DATA TYPE char(4)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE inventar')
20090610:POSTGRESQL=ALTER TABLE inventar ALTER COLUMN bereich TYPE char(4)
20090610:DEFAULT=ALTER TABLE inventar MODIFY bereich char(4)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE inventartmp ALTER COLUMN bereich char(4)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE inventartmp ALTER COLUMN bereich SET DATA TYPE char(4)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE inventartmp')
20090610:POSTGRESQL=ALTER TABLE inventartmp ALTER COLUMN bereich TYPE char(4)
20090610:DEFAULT=ALTER TABLE inventartmp MODIFY bereich char(4)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE abibereich ALTER COLUMN bereich char(4)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE abibereich ALTER COLUMN bereich SET DATA TYPE char(4)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE abibereich')
20090610:POSTGRESQL=ALTER TABLE abibereich ALTER COLUMN bereich TYPE char(4)
20090610:DEFAULT=ALTER TABLE abibereich MODIFY bereich char(4)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe01 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe01 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe01 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe01 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe02 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe02 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe02 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe02 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe03 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe03 SET DATA TYPE char(10)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE permissions')
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe03 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe03 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe04 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe04 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe04 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe04 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe05 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe05 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe05 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe05 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe06 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe06 SET DATA TYPE char(10)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE permissions')
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe06 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe06 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe07 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe07 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe07 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe07 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe08 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe08 SET DATA TYPE char(10)
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe08 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe08 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe09 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe09 SET DATA TYPE char(10)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE permissions')
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe09 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe09 char(10)
20090610:RESETDEFAULT

20090610:HSQLDBSQL=ALTER TABLE permissions ALTER COLUMN oe10 char(10)
20090610:DERBY=NOOPERATION
20090610:MSSQL=NOOPERATION
20090610:DB2=ALTER TABLE permissions ALTER COLUMN oe10 SET DATA TYPE char(10)
20090610:DB2=CALL SYSPROC.ADMIN_CMD('REORG TABLE permissions')
20090610:POSTGRESQL=ALTER TABLE permissions ALTER COLUMN oe10 TYPE char(10)
20090610:DEFAULT=ALTER TABLE permissions MODIFY oe10 char(10)
20090610:RESETDEFAULT

20090610:RUN de.hallobtf.Kai.utils.convert.ConvertDerbyMsSqlOrgEinhBereich 

20090610:update btfsystem set dbversion=20090610

20090611:ALTER TABLE mandanten add featurecode varchar(255)
20090611:drop table btfsystem
20090611:CREATE TABLE btfsystem (dbversion int, systemid char(16))
20090611:INSERT INTO btfsystem (dbversion, systemid) VALUES(0, '0000000000000000')
20090611:RUN de.hallobtf.Kai.utils.convert.CreateSystemId
20090611:update btfsystem set dbversion=20090611

20090612:UPDATE anltabfields set keyformat='alle Zeichen' where keyformat='Alle Zeichen'
20090612:update btfsystem set dbversion=20090612

20090613:ALTER TABLE freeitemsdef add withsign int default 1
20090613:ALTER TABLE anltabfields add withsign int default 1
20090613:update btfsystem set dbversion=20090613

20090614:MSSQL=UPDATE bewcolvalue SET bewcolvalue.value = (SUBSTRING(bewcolvalue.value, 7, 4) + SUBSTRING(bewcolvalue.value, 4, 2) + SUBSTRING(bewcolvalue.value, 1, 2)) WHERE EXISTS (SELECT 1 FROM freeitemsdef WHERE bewcolvalue.mandant = freeitemsdef.mandant AND bewcolvalue.name=freeitemsdef.name and freeitemsdef.datatyp = 'Datum     ')
20090614:DERBY=UPDATE bewcolvalue SET bewcolvalue.value = (SUBSTR(bewcolvalue.value, 7, 4) || SUBSTR(bewcolvalue.value, 4, 2) || SUBSTR(bewcolvalue.value, 1, 2)) WHERE EXISTS (SELECT 1 FROM freeitemsdef WHERE bewcolvalue.mandant = freeitemsdef.mandant AND bewcolvalue.name=freeitemsdef.name and freeitemsdef.datatyp = 'Datum     ')
20090614:POSTGRESQL=UPDATE bewcolvalue SET value = (SUBSTRING(bewcolvalue.value, 7, 4) || SUBSTRING(bewcolvalue.value, 4, 2) || SUBSTRING(bewcolvalue.value, 1, 2)) WHERE EXISTS (SELECT 1 FROM freeitemsdef WHERE bewcolvalue.mandant = freeitemsdef.mandant AND bewcolvalue.name=freeitemsdef.name and freeitemsdef.datatyp = 'Datum     ')
20090614:DB2=UPDATE bewcolvalue SET bewcolvalue.value = (SUBSTR(bewcolvalue.value, 7, 4) || SUBSTR(bewcolvalue.value, 4, 2) || SUBSTR(bewcolvalue.value, 1, 2)) WHERE EXISTS (SELECT 1 FROM freeitemsdef WHERE bewcolvalue.mandant = freeitemsdef.mandant AND bewcolvalue.name=freeitemsdef.name and freeitemsdef.datatyp = 'Datum     ')
20090614:DEFAULT=UPDATE bewcolvalue SET bewcolvalue.value = (SUBSTR(bewcolvalue.value, 7, 4) + SUBSTR(bewcolvalue.value, 4, 2) + SUBSTR(bewcolvalue.value, 1, 2)) WHERE EXISTS (SELECT 1 FROM freeitemsdef WHERE bewcolvalue.mandant = freeitemsdef.mandant AND bewcolvalue.name=freeitemsdef.name and freeitemsdef.datatyp = 'Datum     ')
20090614:RESETDEFAULT
20090614:update btfsystem set dbversion=20090614

20090615:ALTER TABLE mandanten add standortextern int default 0
20090615:update btfsystem set dbversion=20090615

20091122:ALTER TABLE mandanten add importtab char(8)
20091122:update btfsystem set dbversion=20091122

20091204:ALTER TABLE ergebnisliste add nachbemerkung varchar(100)
20091204:update btfsystem set dbversion=20091204

20091210:RUN de.hallobtf.Kai.utils.convert.CreateInventarIndex
20091210:update btfsystem set dbversion=20091210

20091211:ALTER TABLE rubrik add fsichtbar varchar(255)
20091211:RUN de.hallobtf.Kai.utils.convert.ConvertRubrikenSichtbar2Formel
20091211:update btfsystem set dbversion=20091211

20100106:RUN de.hallobtf.Kai.utils.convert.ConvertSuchfelder
20100106:update btfsystem set dbversion=20100106

20100107:RUN de.hallobtf.Kai.utils.convert.AddNachbemerkung
20100107:update btfsystem set dbversion=20100107

20100108:ALTER TABLE abibereich add formel varchar(255)
20100108:update btfsystem set dbversion=20100108

20100109:UPDATE freeitemsdef set laptoppflichtfeld=0 where laptopsyncfeld=0

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungGebaeude char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungGebaeude char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungGebaeude='Geb�ude' where haushalt='   '
20100309:ORACLE=ALTER TABLE mandanten add bezeichnungGebaeude2 char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungGebaeude2 char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungGebaeude2='Geb�ude' where haushalt='   '

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungEtage char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungEtage char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungEtage='Etage' where haushalt='   '
20100309:ORACLE=ALTER TABLE mandanten add bezeichnungEtagen char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungEtagen char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungEtagen='Etagen' where haushalt='   '

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungRaum char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungRaum char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungRaum='Raum' where haushalt='   '
20100309:ORACLE=ALTER TABLE mandanten add bezeichnungRaeume char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungRaeume char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungRaeume='R�ume' where haushalt='   '

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungOrgeinheit char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungOrgeinheit char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungOrgeinheit='Org.-Einheit' where haushalt='   '
20100309:ORACLE=ALTER TABLE mandanten add bezeichnungOrgeinheiten char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungOrgeinheiten char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungOrgeinheiten='Org.-Einheiten' where haushalt='   '

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungBereich char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungBereich char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungBereich='U.-Einheit' where haushalt='   '

20100309:ORACLE=ALTER TABLE mandanten add bezeichnungBereiche char(15 CHAR)
20100309:DEFAULT=ALTER TABLE mandanten add bezeichnungBereiche char(15)
20100309:RESETDEFAULT
20100309:update mandanten set bezeichnungBereiche='U.-Einheiten' where haushalt='   '

20100309:update btfsystem set dbversion=20100309

20100525:ORACLE=ALTER TABLE permissions add be01 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be01 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be02 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be02 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be03 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be03 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be04 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be04 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be05 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be05 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be06 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be06 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be07 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be07 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be08 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be08 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be09 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be09 char(4)
20100525:RESETDEFAULT
20100525:ORACLE=ALTER TABLE permissions add be10 char(4 CHAR)
20100525:DEFAULT=ALTER TABLE permissions add be10 char(4)
20100525:RESETDEFAULT
20100525:update btfsystem set dbversion=20100525

20100527:RUN de.hallobtf.Kai.utils.convert.ConvertStapel
20100527:update btfsystem set dbversion=20100527

20100601:ORACLE=CREATE TABLE paplayout (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, paplayout char(20 CHAR) not null, bezeichnung char(30 CHAR) not null, papierbreite int not null, papierhoehe int not null, papierausrichtung char(1 CHAR) not null, papierrandoben int not null, papierrandunten int not null, papierrandlinks int not null, papierrandrechts int not null, anzahlspalten int not null, anzahlzeilen int not null, etikettenzeilenabstand int not null, etikettenspaltenabstand int not null, PRIMARY KEY  (mandant, haushalt, paplayout))
20100601:DEFAULT=CREATE TABLE paplayout (mandant char(3) not null, haushalt char(4) not null, paplayout char(20) not null, bezeichnung char(30) not null, papierbreite int not null, papierhoehe int not null, papierausrichtung char(1) not null, papierrandoben int not null, papierrandunten int not null, papierrandlinks int not null, papierrandrechts int not null, anzahlspalten int not null, anzahlzeilen int not null, etikettenzeilenabstand int not null, etikettenspaltenabstand int not null, PRIMARY KEY  (mandant, haushalt, paplayout))
20100601:RESETDEFAULT
20100601:DB2=CREATE UNIQUE INDEX paplayout_idx ON paplayout (mandant, haushalt, paplayout)
20100601:RESETDEFAULT
20100601:update btfsystem set dbversion=20100601

20100607:ORACLE=CREATE TABLE etibesch (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, paplayout char(20 CHAR) not null, etibesch char(20 CHAR) not null, bezeichnung char(30 CHAR) not null, invetikett int not null, raumetikett int not null, PRIMARY KEY  (mandant, haushalt, paplayout, etibesch))
20100607:DEFAULT=CREATE TABLE etibesch (mandant char(3) not null, haushalt char(4) not null, paplayout char(20) not null, etibesch char(20) not null, bezeichnung char(30) not null, invetikett int not null, raumetikett int not null, PRIMARY KEY  (mandant, haushalt, paplayout, etibesch))
20100607:RESETDEFAULT
20100607:DB2=CREATE UNIQUE INDEX etibesch_idx ON etibesch (mandant, haushalt, paplayout, etibesch)
20100607:RESETDEFAULT
20100607:update btfsystem set dbversion=20100607

20100610:ORACLE=CREATE TABLE etipos (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, paplayout char(20 CHAR) not null, etibesch char(20 CHAR) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30 CHAR) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255 CHAR), PRIMARY KEY  (mandant, haushalt, paplayout, etibesch, xpos, ypos))
20100610:DEFAULT=CREATE TABLE etipos (mandant char(3) not null, haushalt char(4) not null, paplayout char(20) not null, etibesch char(20) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255), PRIMARY KEY  (mandant, haushalt, paplayout, etibesch, xpos, ypos))
20100610:RESETDEFAULT
20100610:DB2=CREATE UNIQUE INDEX etipos_idx ON etipos (mandant, haushalt, paplayout, etibesch, xpos, ypos)
20100610:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten
20100610:update btfsystem set dbversion=20100610

20100621:ORACLE=ALTER TABLE mandanten add etibesch char(20 CHAR)
20100621:DEFAULT=ALTER TABLE mandanten add etibesch char(20)
20100621:RESETDEFAULT
20100621:RUN de.hallobtf.Kai.utils.convert.ConvertMandantenBarcode
20100621:update btfsystem set dbversion=20100621

20100630:HSQLDBSQL=ALTER TABLE orgeinheit ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE orgeinheit add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE orgeinheit set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE orgeinheit DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE orgeinheit add bezeichnung varchar(100)
20100630:DERBY=UPDATE orgeinheit set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE orgeinheit DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE orgeinheit ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE orgeinheit ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE orgeinheit ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE orgeinheit MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE orgeinheit MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE bereich ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE bereich add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE bereich set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE bereich DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE bereich add bezeichnung varchar(100)
20100630:DERBY=UPDATE bereich set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE bereich DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE bereich ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE bereich ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE bereich ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE bereich MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE bereich MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE gebaeude ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE gebaeude add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE gebaeude set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE gebaeude DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE gebaeude add bezeichnung varchar(100)
20100630:DERBY=UPDATE gebaeude set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE gebaeude DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE gebaeude ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE gebaeude ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE gebaeude ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE gebaeude MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE gebaeude MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE etagen ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE etagen add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE etagen set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE etagen DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE etagen add bezeichnung varchar(100)
20100630:DERBY=UPDATE etagen set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE etagen DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE etagen ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE etagen ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE etagen ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE etagen MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE etagen MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE raeume ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE raeume add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE raeume set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE raeume DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE raeume add bezeichnung varchar(100)
20100630:DERBY=UPDATE raeume set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE raeume DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE raeume ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE raeume ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE raeume ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE raeume MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE raeume MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE haupttypen ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE haupttypen add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE haupttypen set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE haupttypen DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE haupttypen add bezeichnung varchar(100)
20100630:DERBY=UPDATE haupttypen set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE haupttypen DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE haupttypen ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE haupttypen ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE haupttypen ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE haupttypen MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE haupttypen MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE untertypen ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE untertypen add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE untertypen set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE untertypen DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE untertypen add bezeichnung varchar(100)
20100630:DERBY=UPDATE untertypen set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE untertypen DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE untertypen ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE untertypen ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE untertypen ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE untertypen MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE untertypen MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE mengeneinheit ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE mengeneinheit add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE mengeneinheit set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE mengeneinheit DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE mengeneinheit add bezeichnung varchar(100)
20100630:DERBY=UPDATE mengeneinheit set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE mengeneinheit DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE mengeneinheit ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE mengeneinheit ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE mengeneinheit ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE mengeneinheit MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE mengeneinheit MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT

20100630:HSQLDBSQL=ALTER TABLE rubrik ALTER COLUMN bezeichnung varchar(100)
20100630:DERBY=ALTER TABLE rubrik add bezeichnung2 varchar(100)
20100630:DERBY=UPDATE rubrik set bezeichnung2 = bezeichnung
20100630:DERBY=ALTER TABLE rubrik DROP COLUMN bezeichnung
20100630:DERBY=ALTER TABLE rubrik add bezeichnung varchar(100)
20100630:DERBY=UPDATE rubrik set bezeichnung = bezeichnung2
20100630:DERBY=ALTER TABLE rubrik DROP COLUMN bezeichnung2
20100630:MSSQL=ALTER TABLE rubrik ALTER COLUMN bezeichnung varchar(100)
20100630:DB2=ALTER TABLE rubrik ALTER COLUMN bezeichnung SET DATA TYPE varchar(100)
20100630:POSTGRESQL=ALTER TABLE rubrik ALTER COLUMN bezeichnung TYPE varchar(100)
20100630:ORACLE=ALTER TABLE rubrik MODIFY bezeichnung varchar(100 CHAR)
20100630:DEFAULT=ALTER TABLE rubrik MODIFY bezeichnung varchar(100)
20100630:RESETDEFAULT
20100630:update btfsystem set dbversion=20100630

20100906:ALTER TABLE paplayout add veraenderbar int default 1 not null
20100906:ALTER TABLE etibesch add veraenderbar int default 1 not null
20100906:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten2
20100906:update btfsystem set dbversion=20100906 

20100917:RUN de.hallobtf.Kai.utils.convert.CreateHistoryTextIndex
20100917:update btfsystem set dbversion=20100917

20120523:HSQLDBSQL=CREATE CACHED TABLE suchfelder (mandant char(3) not null, nummer char(30) not null, suchfeld1 varchar(50), suchfeld2 varchar(50), suchfeld3 varchar(50), suchfeld4 varchar(50), suchfeld5 varchar(50), suchfeld6 varchar(50), suchfeld7 varchar(50), suchfeld8 varchar(50), suchfeld9 varchar(50), suchfeld10 varchar(50), suchfeld11 varchar(50), suchfeld12 varchar(50), suchfeld13 varchar(50), suchfeld14 varchar(50), suchfeld15 varchar(50), suchfeld16 varchar(50), suchfeld17 varchar(50), suchfeld18 varchar(50), suchfeld19 varchar(50), suchfeld20 varchar(50), suchfeld21 varchar(50), suchfeld22 varchar(50), suchfeld23 varchar(50), suchfeld24 varchar(50), suchfeld25 varchar(50), suchfeld26 varchar(50), suchfeld27 varchar(50), suchfeld28 varchar(50), suchfeld29 varchar(50), suchfeld30 varchar(50), PRIMARY KEY (mandant,nummer))
20120523:ORACLE=CREATE TABLE suchfelder (mandant char(3 CHAR) not null, nummer char(30 CHAR) not null, suchfeld1 varchar(50 CHAR), suchfeld2 varchar(50 CHAR), suchfeld3 varchar(50 CHAR), suchfeld4 varchar(50 CHAR), suchfeld5 varchar(50 CHAR), suchfeld6 varchar(50 CHAR), suchfeld7 varchar(50 CHAR), suchfeld8 varchar(50 CHAR), suchfeld9 varchar(50 CHAR), suchfeld10 varchar(50 CHAR), suchfeld11 varchar(50 CHAR), suchfeld12 varchar(50 CHAR), suchfeld13 varchar(50 CHAR), suchfeld14 varchar(50 CHAR), suchfeld15 varchar(50 CHAR), suchfeld16 varchar(50 CHAR), suchfeld17 varchar(50 CHAR), suchfeld18 varchar(50 CHAR), suchfeld19 varchar(50 CHAR), suchfeld20 varchar(50 CHAR), suchfeld21 varchar(50 CHAR), suchfeld22 varchar(50 CHAR), suchfeld23 varchar(50 CHAR), suchfeld24 varchar(50 CHAR), suchfeld25 varchar(50 CHAR), suchfeld26 varchar(50 CHAR), suchfeld27 varchar(50 CHAR), suchfeld28 varchar(50 CHAR), suchfeld29 varchar(50 CHAR), suchfeld30 varchar(50 CHAR), PRIMARY KEY (mandant,nummer))
20120523:MSSQL=CREATE TABLE suchfelder (mandant char(3) not null, nummer char(30) not null, suchfeld1 varchar(50), suchfeld2 varchar(50), suchfeld3 varchar(50), suchfeld4 varchar(50), suchfeld5 varchar(50), suchfeld6 varchar(50), suchfeld7 varchar(50), suchfeld8 varchar(50), suchfeld9 varchar(50), suchfeld10 varchar(50), suchfeld11 varchar(50), suchfeld12 varchar(50), suchfeld13 varchar(50), suchfeld14 varchar(50), suchfeld15 varchar(50), suchfeld16 varchar(50), suchfeld17 varchar(50), suchfeld18 varchar(50), suchfeld19 varchar(50), suchfeld20 varchar(50), suchfeld21 varchar(50), suchfeld22 varchar(50), suchfeld23 varchar(50), suchfeld24 varchar(50), suchfeld25 varchar(50), suchfeld26 varchar(50), suchfeld27 varchar(50), suchfeld28 varchar(50), suchfeld29 varchar(50), suchfeld30 varchar(50), PRIMARY KEY (mandant,nummer))
20120523:INFORMIX=CREATE TABLE suchfelder (mandant char(3) not null, nummer char(30) not null, suchfeld1 varchar(50), suchfeld2 varchar(50), suchfeld3 varchar(50), suchfeld4 varchar(50), suchfeld5 varchar(50), suchfeld6 varchar(50), suchfeld7 varchar(50), suchfeld8 varchar(50), suchfeld9 varchar(50), suchfeld10 varchar(50), suchfeld11 varchar(50), suchfeld12 varchar(50), suchfeld13 varchar(50), suchfeld14 varchar(50), suchfeld15 varchar(50), suchfeld16 varchar(50), suchfeld17 varchar(50), suchfeld18 varchar(50), suchfeld19 varchar(50), suchfeld20 varchar(50), suchfeld21 varchar(50), suchfeld22 varchar(50), suchfeld23 varchar(50), suchfeld24 varchar(50), suchfeld25 varchar(50), suchfeld26 varchar(50), suchfeld27 varchar(50), suchfeld28 varchar(50), suchfeld29 varchar(50), suchfeld30 varchar(50), PRIMARY KEY (mandant,nummer))
20120523:POSTGRESQL=CREATE TABLE suchfelder (mandant char(3) not null, nummer char(30) not null, suchfeld1 varchar(50), suchfeld2 varchar(50), suchfeld3 varchar(50), suchfeld4 varchar(50), suchfeld5 varchar(50), suchfeld6 varchar(50), suchfeld7 varchar(50), suchfeld8 varchar(50), suchfeld9 varchar(50), suchfeld10 varchar(50), suchfeld11 varchar(50), suchfeld12 varchar(50), suchfeld13 varchar(50), suchfeld14 varchar(50), suchfeld15 varchar(50), suchfeld16 varchar(50), suchfeld17 varchar(50), suchfeld18 varchar(50), suchfeld19 varchar(50), suchfeld20 varchar(50), suchfeld21 varchar(50), suchfeld22 varchar(50), suchfeld23 varchar(50), suchfeld24 varchar(50), suchfeld25 varchar(50), suchfeld26 varchar(50), suchfeld27 varchar(50), suchfeld28 varchar(50), suchfeld29 varchar(50), suchfeld30 varchar(50), PRIMARY KEY (mandant,nummer))
20120523:DEFAULT=CREATE TABLE suchfelder (mandant char(3) not null, nummer char(30) not null, suchfeld1 varchar(50), suchfeld2 varchar(50), suchfeld3 varchar(50), suchfeld4 varchar(50), suchfeld5 varchar(50), suchfeld6 varchar(50), suchfeld7 varchar(50), suchfeld8 varchar(50), suchfeld9 varchar(50), suchfeld10 varchar(50), suchfeld11 varchar(50), suchfeld12 varchar(50), suchfeld13 varchar(50), suchfeld14 varchar(50), suchfeld15 varchar(50), suchfeld16 varchar(50), suchfeld17 varchar(50), suchfeld18 varchar(50), suchfeld19 varchar(50), suchfeld20 varchar(50), suchfeld21 varchar(50), suchfeld22 varchar(50), suchfeld23 varchar(50), suchfeld24 varchar(50), suchfeld25 varchar(50), suchfeld26 varchar(50), suchfeld27 varchar(50), suchfeld28 varchar(50), suchfeld29 varchar(50), suchfeld30 varchar(50), PRIMARY KEY (mandant,nummer))
20120523:RESETDEFAULT

20120523:DB2=CREATE UNIQUE INDEX suchfelder_idx ON suchfelder (mandant, nummer)
20120523:RESETDEFAULT

20120523:RUN de.hallobtf.Kai.utils.convert.ConvertSuchfeldTable

20120523:ALTER TABLE inventar DROP COLUMN suchfeld1
20120523:ALTER TABLE inventar DROP COLUMN suchfeld2
20120523:ALTER TABLE inventar DROP COLUMN suchfeld3
20120523:ALTER TABLE inventar DROP COLUMN suchfeld4
20120523:ALTER TABLE inventar DROP COLUMN suchfeld5
20120523:ALTER TABLE inventar DROP COLUMN suchfeld6
20120523:ALTER TABLE inventar DROP COLUMN suchfeld7
20120523:ALTER TABLE inventar DROP COLUMN suchfeld8
20120523:ALTER TABLE inventar DROP COLUMN suchfeld9
20120523:ALTER TABLE inventar DROP COLUMN suchfeld10
20120523:ALTER TABLE inventar DROP COLUMN suchfeld11
20120523:ALTER TABLE inventar DROP COLUMN suchfeld12

20120523:CREATE VIEW inventar_view AS SELECT i.*, suchfeld1, suchfeld2, suchfeld3, suchfeld4, suchfeld5, suchfeld6, suchfeld7, suchfeld8, suchfeld9, suchfeld10, suchfeld11, suchfeld12, suchfeld13, suchfeld14, suchfeld15, suchfeld16, suchfeld17, suchfeld18, suchfeld19, suchfeld20, suchfeld21, suchfeld22, suchfeld23, suchfeld24, suchfeld25, suchfeld26, suchfeld27, suchfeld28, suchfeld29, suchfeld30 FROM inventar i LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

20120531:ORACLE=ALTER TABLE inventartmp add fremdschluessel varchar(50 CHAR)
20120531:DEFAULT=ALTER TABLE inventartmp add fremdschluessel varchar(50)
20120531:RESETDEFAULT

20120831:DERBY=NOOPERATION
20120831:DEFAULT=DROP VIEW inventar_view
20120831:RESETDEFAULT

20120831:RUN de.hallobtf.Kai.utils.convert.DeleteSpalteFremdschluessel

20120831:HSQLDBSQL=CREATE TABLE inventarfremd (mandant char(3) not null, nummer char(30) not null, fremdschluessel varchar(50) not null, PRIMARY KEY (mandant,nummer))
20120831:ORACLE=CREATE TABLE inventarfremd (mandant char(3 CHAR) not null, nummer char(30 CHAR) not null, fremdschluessel varchar(50 CHAR) not null, PRIMARY KEY (mandant,nummer))
20120831:DEFAULT=CREATE TABLE inventarfremd (mandant char(3) not null, nummer char(30) not null, fremdschluessel varchar(50) not null, PRIMARY KEY (mandant,nummer))
20120831:RESETDEFAULT
20120831:DB2=CREATE UNIQUE INDEX inventarfremd_idx ON suchfelder (mandant, nummer)
20120831:RESETDEFAULT

20120831:CREATE UNIQUE INDEX inventarfremdkey_idx ON inventarfremd (mandant, fremdschluessel)

20120831:ORACLE=ALTER TABLE zaehlliste add fremdschluessel varchar(50 CHAR)
20120831:DEFAULT=ALTER TABLE zaehlliste add fremdschluessel varchar(50)
20120831:RESETDEFAULT

20120831:HSQLDBSQL=CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20120831:DEFAULT=CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20120831:RESETDEFAULT

20120831:ALTER TABLE mandanten drop column extAppl
20120831:ALTER TABLE mandanten drop column extApplKey

20120907:ORACLE=ALTER TABLE ergebnisliste add fremdschluessel varchar(50 CHAR)
20120907:DEFAULT=ALTER TABLE ergebnisliste add fremdschluessel varchar(50)
20120907:RESETDEFAULT

20120924:MSSQL=NOOPERATION
20120924:DEFAULT=ALTER TABLE mandanten DROP COLUMN standortextern
20120924:RESETDEFAULT

20121012:ORACLE=CREATE TABLE etityp (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, etityp char(20 CHAR) not null, bezeichnung char(30 CHAR) not null, papierbreite int not null, papierhoehe int not null, papierausrichtung char(1 CHAR) not null, papierrandoben int not null, papierrandunten int not null, papierrandlinks int not null, papierrandrechts int not null, anzahlspalten int not null, anzahlzeilen int not null, etikettenzeilenabstand int not null, etikettenspaltenabstand int not null, veraenderbar int default 1 not null, PRIMARY KEY  (mandant, haushalt, etityp))
20121012:DEFAULT=CREATE TABLE etityp (mandant char(3) not null, haushalt char(4) not null, etityp char(20) not null, bezeichnung char(30) not null, papierbreite int not null, papierhoehe int not null, papierausrichtung char(1) not null, papierrandoben int not null, papierrandunten int not null, papierrandlinks int not null, papierrandrechts int not null, anzahlspalten int not null, anzahlzeilen int not null, etikettenzeilenabstand int not null, etikettenspaltenabstand int not null, veraenderbar int default 1 not null, PRIMARY KEY  (mandant, haushalt, etityp))
20121012:RESETDEFAULT

20121012:ORACLE=CREATE TABLE etilay (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, etityp char(20 CHAR) not null, etilay char(20 CHAR) not null, bezeichnung char(30 CHAR) not null, invetikett int not null, raumetikett int not null, veraenderbar int default 1 not null, PRIMARY KEY  (mandant, haushalt, etityp, etilay))
20121012:DEFAULT=CREATE TABLE etilay (mandant char(3) not null, haushalt char(4) not null, etityp char(20) not null, etilay char(20) not null, bezeichnung char(30) not null, invetikett int not null, raumetikett int not null, veraenderbar int default 1 not null, PRIMARY KEY  (mandant, haushalt, etityp, etilay))
20121012:RESETDEFAULT

20121012:ORACLE=CREATE TABLE etipos_tmp (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, paplayout char(20 CHAR) not null, etibesch char(20 CHAR) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30 CHAR) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255 CHAR), PRIMARY KEY  (mandant, haushalt, paplayout, etibesch, xpos, ypos))
20121012:DEFAULT=CREATE TABLE etipos_tmp (mandant char(3) not null, haushalt char(4) not null, paplayout char(20) not null, etibesch char(20) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255), PRIMARY KEY  (mandant, haushalt, paplayout, etibesch, xpos, ypos))
20121012:RESETDEFAULT

20121012:insert into etipos_tmp select mandant, haushalt, paplayout, etibesch, xpos, ypos, breite, ausrichtung, schrift, groesse, fett, kursiv, unterstrichen, formel from etipos

20121012:DROP TABLE etipos

20121012:ORACLE=CREATE TABLE etipos (mandant char(3 CHAR) not null, haushalt char(4 CHAR) not null, etityp char(20 CHAR) not null, etilay char(20 CHAR) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30 CHAR) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255 CHAR), PRIMARY KEY  (mandant, haushalt, etityp, etilay, xpos, ypos))
20121012:DEFAULT=CREATE TABLE etipos (mandant char(3) not null, haushalt char(4) not null, etityp char(20) not null, etilay char(20) not null, xpos int not null, ypos int not null, breite int, ausrichtung int, schrift char(30) not null, groesse int, fett int, kursiv int, unterstrichen int, formel varchar(255), PRIMARY KEY  (mandant, haushalt, etityp, etilay, xpos, ypos))
20121012:RESETDEFAULT

20121012:DB2=CREATE UNIQUE INDEX etitypt_idx ON etityp (mandant, haushalt, etityp)
20121012:DB2=CREATE UNIQUE INDEX etilay_idx ON etilay (mandant, haushalt, etityp, etilay)
20121012:DB2=CREATE UNIQUE INDEX etipos_idx ON etipos (mandant, haushalt, etityp, etilay, xpos, ypos)

20121012:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten3

20121012:DROP TABLE etibesch
20121012:DROP TABLE paplayout
20121012:DROP TABLE etipos_tmp

20121012:ORACLE=ALTER TABLE mandanten add etityp varchar(20 CHAR)
20121012:DEFAULT=ALTER TABLE mandanten add etityp varchar(20)
20121012:RESETDEFAULT

20121012:ORACLE=ALTER TABLE mandanten add etilay varchar(20 CHAR)
20121012:DEFAULT=ALTER TABLE mandanten add etilay varchar(20)
20121012:RESETDEFAULT

20121012:update mandanten set etityp=barcodelayout
20121012:update mandanten set etilay=etibesch

20121012:alter table mandanten drop column barcodelayout
20121012:alter table mandanten drop column etibesch

20121026:update zaehlliste set fremdschluessel=' ' where fremdschluessel='null' 
20121026:update ergebnisliste set fremdschluessel=' ' where fremdschluessel='null'
20121026:update mandanten set invnumformatclass='de.hallobtf.Kai.formatter.AlphaNumericPattern10' where haushalt='0000'

20121116:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten4

20121128:update etityp set papierausrichtung='H' where papierausrichtung='1'
20121128:update etityp set papierausrichtung='Q' where papierausrichtung='0'

20121129:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten5

20130211:ORACLE=ALTER TABLE anltabfields add updatemode CHAR(1 CHAR)
20130211:DEFAULT=ALTER TABLE anltabfields add updatemode CHAR(1)
20130211:RESETDEFAULT

20130211:update anltabfields set updatemode=' '

20130219:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten6

20130228:ORACLE=ALTER TABLE inventartmp add aapplid char(4 CHAR)
20130228:DEFAULT=ALTER TABLE inventartmp add aapplid char(4)
20130228:RESETDEFAULT

20130228:ORACLE=ALTER TABLE inventartmp add anlkey varchar(40 CHAR)
20130228:DEFAULT=ALTER TABLE inventartmp add anlkey varchar(40)
20130228:RESETDEFAULT

20130228:ORACLE=ALTER TABLE inventartmp add noaanlbu char(1 CHAR)
20130228:DEFAULT=ALTER TABLE inventartmp add noaanlbu char(1)
20130228:RESETDEFAULT

20130228:ORACLE=ALTER TABLE inventartmp add batchnum varchar(18 CHAR)
20130228:DEFAULT=ALTER TABLE inventartmp add batchnum varchar(18)
20130228:RESETDEFAULT

20130228:ORACLE=ALTER TABLE inventartmp add iskoppelnummer char(1 CHAR) 
20130228:DEFAULT=ALTER TABLE inventartmp add iskoppelnummer char(1) 
20130228:RESETDEFAULT

20130229:RUN de.hallobtf.Kai.utils.convert.ConvertInventarTmp2

20130307:ORACLE=ALTER TABLE etilay add ordner varchar(255 CHAR)
20130307:DEFAULT=ALTER TABLE etilay add ordner varchar(255)
20130307:RESETDEFAULT

20130307:ORACLE=ALTER TABLE etilay add dateiname varchar(255 CHAR)
20130307:DEFAULT=ALTER TABLE etilay add dateiname varchar(255)
20130307:RESETDEFAULT

20130307:ORACLE=ALTER TABLE etilay add dateiendung varchar(255 CHAR)
20130307:DEFAULT=ALTER TABLE etilay add dateiendung varchar(255)
20130307:RESETDEFAULT

20130315:RUN de.hallobtf.Kai.utils.convert.ConvertEtiketten7

# 20130508:alter table rubrik drop column sichtbar
# 20130508:alter table freeitemsdef drop column laptoplistfeld

20130522:alter table etilay add anlagenetikett int default 0

20131001:ORACLE=ALTER TABLE abistamm add zyklus varchar(12 CHAR)
20131001:DEFAULT=ALTER TABLE abistamm add zyklus varchar(12)
20131001:RESETDEFAULT

20131008:ORACLE=ALTER TABLE inventar add datumletzteinvent varchar(8 CHAR)
20131008:DEFAULT=ALTER TABLE inventar add datumletzteinvent varchar(8)
20131008:RESETDEFAULT
20131008:ORACLE=ALTER TABLE inventar add datumerfassung varchar(8 CHAR)
20131008:DEFAULT=ALTER TABLE inventar add datumerfassung varchar(8)
20131008:RESETDEFAULT

20131009:RUN de.hallobtf.Kai.utils.convert.InitDatumErfassungInventur

20131010:DROP VIEW inventar_view
20131010:HSQLDBSQL=CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20131010:DEFAULT=CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20131010:RESETDEFAULT

20131203:DELETE FROM suchfelder WHERE NOT EXISTS (SELECT 1 FROM inventar where inventar.mandant = suchfelder.mandant AND inventar.nummer = suchfelder.nummer)

20141117:ORACLE=CREATE TABLE meldeclientconfig (mandant char(3 CHAR) not null, emailadresse varchar(255 CHAR), smpthost varchar(255 CHAR), smtpport char(5 CHAR), emailmessagefield1 varchar(255 CHAR), emailmessagefield2 varchar(255 CHAR), emailmessagefield3 varchar(255 CHAR), emailmessagefield4 varchar(255 CHAR), emailbetreff char(255 CHAR), meldeclientuser varchar(8 CHAR), leitfadenlink varchar(255 CHAR), PRIMARY KEY  (mandant))
20141117:DEFAULT=CREATE TABLE meldeclientconfig (mandant char(3) not null, emailadresse varchar(255), smtphost varchar(255), smtpport char(5), emailmessagefield1 varchar(255), emailmessagefield2 varchar(255), emailmessagefield3 varchar(255), emailmessagefield4 varchar(255), emailbetreff varchar(255), meldeclientuser varchar(8), leitfadenlink varchar(255), PRIMARY KEY  (mandant))
20141117:RESETDEFAULT

20150112:ORACLE=ALTER TABLE meldeclientconfig RENAME COLUMN smpthost TO smtphost
20150112:DEFAULT=NOOPERATION
20150112:RESETDEFAULT

################################################################################
#
# Kai 02.02 (Update)
#
################################################################################
20170101:RUN de.hallobtf.Kai.utils.convert.CheckDatabaseType
20170101:RUN de.hallobtf.Kai.utils.convert.DropOldJournal
20170101:ORACLE=CREATE TABLE journal (mandant char(3 CHAR), haushalt char(4 CHAR), zeitstempel char(18 CHAR), userid varchar(50 CHAR), tac char(12 CHAR), opc char(4 CHAR), rc int, msg varchar(255 CHAR), hasdetail char(1 CHAR), PRIMARY KEY(mandant, haushalt, zeitstempel))  
20170101:DEFAULT=CREATE TABLE journal (mandant char(3), haushalt char(4), zeitstempel char(18), userid varchar(50), tac char(12), opc char(4), rc int, msg varchar(255), hasdetail char(1), PRIMARY KEY(mandant, haushalt, zeitstempel))  
20170101:RESETDEFAULT
20170101:ORACLE=CREATE TABLE journaldetail (mandant char(3 CHAR), haushalt char(4 CHAR), zeitstempel char(18 CHAR), lfdnr int, feldname varchar(50 CHAR), alterwert varchar(255 CHAR), neuerwert varchar(255 CHAR), PRIMARY KEY (mandant, haushalt, zeitstempel, lfdnr))   
20170101:DEFAULT=CREATE TABLE journaldetail (mandant char(3), haushalt char(4), zeitstempel char(18), lfdnr int, feldname varchar(50), alterwert varchar(255), neuerwert varchar(255), PRIMARY KEY (mandant, haushalt, zeitstempel, lfdnr))
20170101:RESETDEFAULT

20170101:ORACLE=CREATE TABLE suchkriterien(mandant char(3 CHAR), haushalt char(4 CHAR), userid varchar(50 CHAR), kriterium varchar(20 CHAR), beschreibung varchar(255 CHAR), wert1 varchar(255 CHAR), wert2 varchar(255 CHAR), wert3 varchar(255 CHAR), wert4 varchar(255 CHAR), wert5 varchar(255 CHAR), wert6 varchar(255 CHAR), PRIMARY KEY(mandant, haushalt, userid, kriterium))
20170101:DEFAULT=CREATE TABLE suchkriterien(mandant char(3), haushalt char(4), userid varchar(50), kriterium varchar(20), beschreibung varchar(255), wert1 varchar(255), wert2 varchar(255), wert3 varchar(255), wert4 varchar(255), wert5 varchar(255), wert6 varchar(255), PRIMARY KEY(mandant, haushalt, userid, kriterium))
20170101:RESETDEFAULT

20170101:ORACLE=ALTER TABLE ergebnisliste add grundabgang varchar(100 CHAR) 
20170101:DEFAULT=ALTER TABLE ergebnisliste add grundabgang varchar(100)
20170101:RESETDEFAULT

20170101:DROP TABLE sperre
20170101:ORACLE=CREATE TABLE sperre (mandant char(3 CHAR), userid varchar(50 CHAR), PRIMARY KEY  (mandant))
20170101:DEFAULT=CREATE TABLE sperre (mandant char(3), userid varchar(50), PRIMARY KEY  (mandant))
20170101:RESETDEFAULT

20170101:ALTER TABLE mandanten ADD noanlbu int
20170101:UPDATE permissions SET p_admin=0 WHERE buckr<>'    '
20170101:RUN de.hallobtf.Kai.utils.convert.ConvertUserid
20170101:RUN de.hallobtf.Kai.utils.convert.CheckInventuren
20170101:RUN de.hallobtf.Kai.utils.convert.InsertBuchungskreis
20170101:RUN de.hallobtf.Kai.utils.convert.ConvertConnections

20170101:RUN de.hallobtf.Kai.utils.convert.ConvertPrimaryKeys

20170101:DROP VIEW inventar_view
20170101:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

20170214:ORACLE=ALTER TABLE connections ADD proxyserver varchar(255 CHAR)
20170214:DEFAULT=ALTER TABLE connections ADD proxyserver varchar(255)
20170214:RESETDEFAULT
20170214:ORACLE=ALTER TABLE connections ADD clientcertificate varchar(255 CHAR)
20170214:DEFAULT=ALTER TABLE connections ADD clientcertificate varchar(255)
20170214:RESETDEFAULT
20170214:ORACLE=ALTER TABLE connections ADD clientcertificatepassphrase varchar(255 CHAR)
20170214:DEFAULT=ALTER TABLE connections ADD clientcertificatepassphrase varchar(255)
20170214:RESETDEFAULT
20170214:ORACLE=ALTER TABLE connections ADD servercertificate varchar(255 CHAR)
20170214:DEFAULT=ALTER TABLE connections ADD servercertificate varchar(255)
20170214:RESETDEFAULT
20170214:ORACLE=ALTER TABLE connections ADD servercertificatepassphrase varchar(255 CHAR)
20170214:DEFAULT=ALTER TABLE connections ADD servercertificatepassphrase varchar(255)
20170214:RESETDEFAULT

20170316:RUN de.hallobtf.Kai.utils.convert.ConvertAnlBuConnections
20170316:RUN de.hallobtf.Kai.utils.convert.ConvertLizenz

20170323:ORACLE=ALTER TABLE meldeclientconfig ADD usessl int
20170323:DEFAULT=ALTER TABLE meldeclientconfig ADD usessl int
20170323:RESETDEFAULT
20170323:ORACLE=ALTER TABLE meldeclientconfig ADD username varchar(255 CHAR)
20170323:DEFAULT=ALTER TABLE meldeclientconfig ADD username varchar(255)
20170323:RESETDEFAULT
20170323:ORACLE=ALTER TABLE meldeclientconfig ADD password varchar(255 CHAR)
20170323:DEFAULT=ALTER TABLE meldeclientconfig ADD password varchar(255)
20170323:RESETDEFAULT
20170323:MSSQL=ALTER TABLE meldeclientconfig ALTER COLUMN meldeclientuser varchar(50)
20170323:DERBY=ALTER TABLE meldeclientconfig ALTER COLUMN meldeclientuser set data type varchar(50)
20170323:ORACLE=ALTER TABLE meldeclientconfig MODIFY meldeclientuser varchar(50 CHAR)
20170323:DEFAULT=ALTER TABLE meldeclientconfig MODIFY meldeclientuser varchar(50)
20170323:RESETDEFAULT

20170404:ALTER TABLE benutzer ADD gesperrt int

20170418:DROP TABLE sperre
20170418:ORACLE=CREATE TABLE sperre (mandant char(3 CHAR), userid varchar(50 CHAR), sperrtext varchar(255 CHAR), PRIMARY KEY  (mandant))
20170418:DEFAULT=CREATE TABLE sperre (mandant char(3), userid varchar(50), sperrtext varchar(255), PRIMARY KEY  (mandant))
20170418:RESETDEFAULT

20170418:UPDATE mandanten set invnumformatclass='de.hallobtf.Kai.formatter.GenericPattern10' where haushalt='0000'

20171117:DROP VIEW inventar_view
20171117:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20171117:ORACLE=ALTER TABLE connections ADD userid varchar(50 CHAR)
20171117:DEFAULT=ALTER TABLE connections ADD userid varchar(50)
20171117:RESETDEFAULT
20171117:ORACLE=ALTER TABLE connections ADD passwd varchar(255 CHAR)
20171117:DEFAULT=ALTER TABLE connections ADD passwd varchar(255)
20171117:RESETDEFAULT

20180507:UPDATE permissions set p_admin=2 where mandant='   ' and p_admin=1

20181122:ORACLE=CREATE TABLE inventarfoto(mandant char(3 CHAR), haushalt char(4 CHAR), nummer char(30 CHAR), daten blob not null, PRIMARY KEY(mandant,haushalt,nummer))
20181122:MSSQL=CREATE TABLE inventarfoto(mandant char(3), haushalt char(4), nummer char(30), daten varbinary(max) not null, PRIMARY KEY(mandant,haushalt,nummer))
20181122:DERBY=CREATE TABLE inventarfoto(mandant char(3), haushalt char(4), nummer char(30), daten blob not null, PRIMARY KEY(mandant,haushalt,nummer))
20181122:DEFAULT=CREATE TABLE inventarfoto(mandant char(3), haushalt char(4), nummer char(30), daten longblob not null, PRIMARY KEY(mandant,haushalt,nummer))
20181122:RESETDEFAULT
20181122:ORACLE=CREATE TABLE inventarfototmp(mandant char(3 CHAR), haushalt char(4 CHAR), abinummer char(10 CHAR), gangnr char(3 CHAR), nummer char(30 CHAR), daten blob not null, PRIMARY KEY(mandant,haushalt,abinummer,gangnr,nummer))
20181122:MSSQL=CREATE TABLE inventarfototmp(mandant char(3), haushalt char(4), abinummer char(10), gangnr char(3), nummer char(30), daten varbinary(max) not null, PRIMARY KEY(mandant,haushalt,abinummer,gangnr,nummer))
20181122:DERBY=CREATE TABLE inventarfototmp(mandant char(3), haushalt char(4), abinummer char(10), gangnr char(3), nummer char(30), daten blob not null, PRIMARY KEY(mandant,haushalt,abinummer,gangnr,nummer))
20181122:DEFAULT=CREATE TABLE inventarfototmp(mandant char(3), haushalt char(4), abinummer char(10), gangnr char(3), nummer char(30), daten longblob not null, PRIMARY KEY(mandant,haushalt,abinummer,gangnr,nummer))
20181122:RESETDEFAULT

20190128:ORACLE=ALTER TABLE inventar ADD withfoto char(1 CHAR)
20190128:DEFAULT=ALTER TABLE inventar ADD withfoto char(1)
20190128:ORACLE=ALTER TABLE inventartmp ADD withfoto char(1 CHAR)
20190128:DEFAULT=ALTER TABLE inventartmp ADD withfoto char(1)
20190128:ORACLE=ALTER TABLE zaehlliste ADD withfoto char(1 CHAR)
20190128:DEFAULT=ALTER TABLE zaehlliste ADD withfoto char(1)
20190128:DROP VIEW inventar_view
20190128:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20190128:RESETDEFAULT

################################################################################
#
# Kai 02.03 (Update)
#
################################################################################

20200228:ORACLE=ALTER TABLE btfsystem ADD lizenz clob
20200228:DERBY=ALTER TABLE btfsystem ADD lizenz clob
20200228:DEFAULT=ALTER TABLE btfsystem ADD lizenz text
20200228:RESETDEFAULT
20200228:RUN de.hallobtf.Kai.utils.convert.CreateLizenz

20200229:ORACLE=CREATE TABLE tmpmandanten (mandant char(3 CHAR), haushalt char(4 CHAR), bezeichnung varchar(30 CHAR), barcodehead varchar(25 CHAR), barcodefoot varchar(25 CHAR), conname char(8 CHAR), dialogtab char(8 CHAR), importtab char(8 CHAR), exporttab char(8 CHAR), invnumformatclass varchar(255 CHAR), exportdir varchar(255 CHAR), extinherit int, autoinvnum int, etityp varchar(20 CHAR), etilay varchar(20 CHAR), invnummervorb char(30 CHAR), featurecode varchar(255 CHAR), bezeichnungGebaeude char(15 CHAR), bezeichnungGebaeude2 char(15 CHAR), bezeichnungEtage char(15 CHAR), bezeichnungEtagen char(15 CHAR), bezeichnungRaum char(15 CHAR), bezeichnungRaeume char(15 CHAR), bezeichnungOrgeinheiten char(15 CHAR), bezeichnungOrgeinheit char(15 CHAR), bezeichnungBereich char(15 CHAR), bezeichnungBereiche char(15 CHAR), noanlbu int, PRIMARY KEY  (mandant,haushalt))
20200229:DEFAULT=CREATE TABLE tmpmandanten (mandant char(3), haushalt char(4), bezeichnung varchar(30), barcodehead varchar(25), barcodefoot varchar(25), conname char(8), dialogtab char(8), importtab char(8), exporttab char(8), invnumformatclass varchar(255), exportdir varchar(255), extinherit int, autoinvnum int, etityp varchar(20), etilay varchar(20), invnummervorb char(30), featurecode varchar(255), bezeichnungGebaeude char(15), bezeichnungGebaeude2 char(15), bezeichnungEtage char(15), bezeichnungEtagen char(15), bezeichnungRaum char(15), bezeichnungRaeume char(15), bezeichnungOrgeinheiten char(15), bezeichnungOrgeinheit char(15), bezeichnungBereich char(15), bezeichnungBereiche char(15), noanlbu int, PRIMARY KEY  (mandant,haushalt))
20200229:RESETDEFAULT
20200229:INSERT INTO tmpmandanten select mandant,haushalt,bezeichnung,barcodehead,barcodefoot,conname,dialogtab,importtab,exporttab,invnumformatclass,exportdir,extinherit,autoinvnum,etityp,etilay,invnummervorb,featurecode,bezeichnungGebaeude,bezeichnungGebaeude2,bezeichnungEtage,bezeichnungEtagen,bezeichnungRaum,bezeichnungRaeume,bezeichnungOrgeinheiten,bezeichnungOrgeinheit,bezeichnungBereich,bezeichnungBereiche,noanlbu from mandanten
20200229:DROP TABLE mandanten
20200229:CREATE TABLE mandanten (mandant varchar(3), bezeichnung varchar(255), BUSINESS KEY(mandant))
20200229:CREATE TABLE buchungskreise (mandant varchar(3), buckr varchar(4), bezeichnung varchar(255), barcodehead varchar(255), barcodefoot varchar(255), conname varchar(8), dialogtab varchar(8), importtab varchar(8), exporttab varchar(8), invnumformatclass varchar(255), exportdir varchar(255), autoinvnum int, noanlbu int, etityp varchar(20), etilay varchar(20), invnummervorb varchar(30), bezeichnungGebaeude varchar(50), bezeichnungGebaeude2 varchar(50), bezeichnungEtage varchar(50), bezeichnungEtagen varchar(50), bezeichnungRaum varchar(50), bezeichnungRaeume varchar(50), bezeichnungOrgeinheiten varchar(50), bezeichnungOrgeinheit varchar(50), bezeichnungBereich varchar(50), bezeichnungBereiche varchar(50), BUSINESS KEY(mandant,buckr))
20200229:RUN de.hallobtf.Kai.utils.convert.ConvertMandanten
20200229:DROP TABLE tmpmandanten

20200331:DROP TABLE btfparameter

20200401:RUN de.hallobtf.Kai.utils.convert.ConvertPrimaryKeys2
20200402:RUN de.hallobtf.Kai.utils.convert.CreateLayoutDef

20200520:CREATE TABLE tmpbenutzer (mandant varchar(3), userid varchar(50), passwd varchar(20), pwddate varchar(8), faultylogin int, lastlogin varchar(18), lastloginok int, name varchar(100), email varchar(100), permissionparent varchar(50), gesperrt int, BUSINESS KEY(mandant, userid))
20200520:INSERT INTO tmpbenutzer (mandant, userid, passwd, pwddate, faultylogin, lastlogin, lastloginok, name, email, permissionparent, gesperrt) select mandant, userid, passwd, pwddate, faultylogin, lastlogin, lastloginok, name, email, permissionparent, gesperrt from benutzer
20200520:DROP TABLE benutzer
20200520:ORACLE=CREATE TABLE benutzer (mandant varchar(3), userid varchar(50), passwd varchar(20), pwddate date, faultylogin int, lastlogin date, lastloginok int, name varchar(100), email varchar(100), permissionparent varchar(50), gesperrt int, BUSINESS KEY(mandant, userid))
20200520:DERBY=CREATE TABLE benutzer (mandant varchar(3), userid varchar(50), passwd varchar(20), pwddate timestamp, faultylogin int, lastlogin timestamp, lastloginok int, name varchar(100), email varchar(100), permissionparent varchar(50), gesperrt int, BUSINESS KEY(mandant, userid))
20200520:DEFAULT=CREATE TABLE benutzer (mandant varchar(3), userid varchar(50), passwd varchar(20), pwddate datetime, faultylogin int, lastlogin datetime, lastloginok int, name varchar(100), email varchar(100), permissionparent varchar(50), gesperrt int, BUSINESS KEY(mandant, userid))
20200520:RESETDEFAULT
20200520:RUN de.hallobtf.Kai.utils.convert.ConvertUserTimestamps
20200520:DROP TABLE tmpbenutzer

20200618:ORACLE=ALTER TABLE inventar add datumstatusaenderung varchar(8 CHAR)
20200618:DEFAULT=ALTER TABLE inventar add datumstatusaenderung varchar(8)
20200618:RESETDEFAULT
20200618:ORACLE=ALTER TABLE inventar add useridstatusaenderung varchar(50 CHAR)
20200618:DEFAULT=ALTER TABLE inventar add useridstatusaenderung varchar(50)
20200618:RESETDEFAULT
20200618:DROP VIEW inventar_view
20200618:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer
20200618:RUN de.hallobtf.Kai.utils.convert.InitLetzteStatusAenderung

20200724:DROP TABLE stapel
20200724:CREATE TABLE stapel (mandant varchar(3), haushalt varchar(4), userid varchar(50), modus varchar(1), nummer varchar(30), zuordnung varchar(1), BUSINESS KEY(mandant,haushalt,userid,modus,nummer))

20200812:ORACLE=ALTER TABLE mandanten add beschreibung clob
20200812:DERBY=ALTER TABLE mandanten add beschreibung clob
20200812:MYSQL=ALTER TABLE mandanten add beschreibung mediumtext
20200812:DEFAULT=ALTER TABLE mandanten add beschreibung text
20200812:RESETDEFAULT

20200813:CREATE TABLE tmpsperre (mandant char(3), userid varchar(50), sperrtext varchar(255), BUSINESS KEY (mandant))
20200813:INSERT INTO tmpsperre (mandant, userid, sperrtext) SELECT mandant, userid, sperrtext from sperre
20200813:DROP TABLE sperre

20200813:ORACLE=CREATE TABLE sperre (mandant varchar(3), userid varchar(50), sperrtext clob, BUSINESS KEY (mandant))
20200813:DERBY=CREATE TABLE sperre (mandant varchar(3), userid varchar(50), sperrtext clob, BUSINESS KEY (mandant))
20200813:MYSQL=CREATE TABLE sperre (mandant varchar(3), userid varchar(50), sperrtext mediumtext, BUSINESS KEY (mandant))
20200813:DEFAULT=CREATE TABLE sperre (mandant varchar(3), userid varchar(50), sperrtext text, BUSINESS KEY (mandant))
20200813:RESETDEFAULT

20200813:INSERT INTO sperre (mandant, userid, sperrtext) SELECT mandant, userid, sperrtext from tmpsperre
20200813:DROP TABLE tmpsperre

20200814:ALTER TABLE benutzer add oldpwd1 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd2 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd3 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd4 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd5 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd6 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd7 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd8 varchar(20)
20200814:ALTER TABLE benutzer add oldpwd9 varchar(20)
20200814:ALTER TABLE benutzer add isinitpwd int

20200815:UPDATE connections SET type='Client' WHERE type<>'Local' AND type<>'IpLen5'

20210119:DROP VIEW inventar_view
20210119:ALTER TABLE inventar ADD freeitemsdata clob(64000)
20210119:ALTER TABLE inventartmp ADD freeitemsdata clob(64000)
20210119:RUN de.hallobtf.Kai.utils.convert.ConvertFreeItemsToClob
20210119:RUN de.hallobtf.Kai.utils.convert.ConvertSuchfelder2
20210119:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

20210120:SQLITE=NOOPERATION
20210120:DERBY=NOOPERATION
20210120:ORACLE=NOOPERATION
20210120:MSSQL=ALTER TABLE btfsystem ALTER COLUMN lizenz clob(10000000)
20210120:DEFAULT=ALTER TABLE btfsystem MODIFY lizenz clob(10000000)
20210120:RESETDEFAULT
20210120:SQLITE=NOOPERATION
20210120:DERBY=NOOPERATION
20210120:ORACLE=NOOPERATION
20210120:MSSQL=ALTER TABLE mandanten ALTER COLUMN beschreibung clob(64000)
20210120:DEFAULT=ALTER TABLE mandanten MODIFY beschreibung clob(64000)
20210120:RESETDEFAULT
20210120:SQLITE=NOOPERATION
20210120:DERBY=NOOPERATION
20210120:ORACLE=NOOPERATION
20210120:MSSQL=ALTER TABLE sperre ALTER COLUMN sperrtext clob(64000)
20210120:DEFAULT=ALTER TABLE sperre MODIFY sperrtext clob(64000)
20210120:RESETDEFAULT
20210120:SQLITE=NOOPERATION
20210120:DERBY=NOOPERATION
20210120:ORACLE=NOOPERATION
20210120:MSSQL=ALTER TABLE inventarfoto ALTER COLUMN daten blob(10000000)
20210120:DEFAULT=ALTER TABLE inventarfoto MODIFY daten blob(10000000)
20210120:RESETDEFAULT
20210120:SQLITE=NOOPERATION
20210120:DERBY=NOOPERATION
20210120:ORACLE=NOOPERATION
20210120:MSSQL=ALTER TABLE inventarfototmp ALTER COLUMN daten blob(10000000)
20210120:DEFAULT=ALTER TABLE inventarfototmp MODIFY daten blob(10000000)
20210120:RESETDEFAULT

20210121:CREATE TABLE documenttemplate(mandant varchar(3), buckr varchar(4), templateid varchar(36), name varchar(100), description varchar(255), title varchar(255), doctype varchar(10), doccat varchar(10), filename varchar(255), subscribed int, standard int, author varchar(50), lastmodified timestamp, filesize int, signature varchar(100), BUSINESS KEY(mandant, buckr, templateid))
20210121:CREATE TABLE documenttemplatedata(mandant varchar(3), buckr varchar(4), templateid varchar(36), packid int, daten blob(64000), BUSINESS KEY(mandant, buckr, templateid, packid))
20210121:ALTER TABLE benutzer add docpath varchar(255)
20210121:DROP TABLE suchkriterien
20210121:CREATE TABLE suchkriterien(mandant varchar(3), buckr varchar(4), userid varchar(50), name varchar(20), suchart varchar(10), zuordnung varchar(10), invnummer varchar(30), fremdschluessel varchar(50), invmuster varchar(30), issuchebez int, issuchebes int, invbez varchar(255), haupttyp varchar(3), untertyp varchar(3), standort1 varchar(10), standort2 varchar(4), standort3 varchar(6), orgeinheit varchar(10), bereich varchar(4), listart varchar(10), kennzdatumvon varchar(3), kennzdatumbis varchar(3), invdatumvon timestamp, invdatumbis timestamp, status varchar(10), freeitemswerte clob(64000), bewegungenwerte clob(64000), BUSINESS KEY(mandant, buckr, userid, name))

20210122:RUN de.hallobtf.Kai.utils.convert.ConvertHisDetail

20210309:ALTER TABLE btfsystem ADD globalparams clob(10000000)

20210506:RUN de.hallobtf.Kai.utils.convert.ConvertSuchfelder2
20210506:DROP VIEW inventar_view
20210506:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

20210628:CREATE TABLE printoptions(mandant varchar(3), buckr varchar(4), userid varchar(50), doccat varchar(10), name varchar(20), sortandgroup clob(64000), fieldsandhist clob(64000), BUSINESS KEY(mandant, buckr, userid, doccat, name))

20210924:DROP TABLE printoptions
20210924:CREATE TABLE printoptions(mandant varchar(3), buckr varchar(4), userid varchar(50), doccat varchar(10), name varchar(20), sortfields clob(2048), maxgwidx int, nurgefuelltefelder int, mitallghist int, fieldsandhist clob(64000), BUSINESS KEY(mandant, buckr, userid, doccat, name))

20211117:UPDATE inventar set anlkey=null where anlkey=' ' or anlkey='                                        '

20220921:UPDATE stapel set modus='I' where modus=' '
20220921:UPDATE stapel set zuordnung='?' where zuordnung='?'

20230601:RUN de.hallobtf.Kai.utils.convert.TrimFremdschluessel
20231013:ALTER TABLE freeitemsdef ADD bemerkung varchar(255)
20231013:UPDATE freeitemsdef SET bemerkung=(SELECT trim(bemerkung) FROM freeitemsext WHERE mandant=freeitemsdef.mandant AND haushalt=freeitemsdef.haushalt AND haupttyp=freeitemsdef.haupttyp AND untertyp=freeitemsdef.untertyp AND name=freeitemsdef.name)
20231013:DROP TABLE freeitemsext
20231013:ALTER TABLE anltabfields ADD bemerkung varchar(255)
20231013:UPDATE anltabfields SET bemerkung=(SELECT trim(bemerkung) FROM anltabfieldext WHERE mandant=anltabfields.mandant AND haushalt=anltabfields.haushalt AND tabname=anltabfields.tabname AND fieldname=anltabfields.fieldname)
20231013:DROP TABLE anltabfieldext

20231016:RUN de.hallobtf.Kai.utils.convert.ConvertLizenz2

20231211:RUN de.hallobtf.Kai.utils.convert.ConvertLizenz3

20240226:ALTER TABLE connections ADD configparams clob(64000)
20240226:RUN de.hallobtf.Kai.utils.convert.ConvertConnectionsToClob

20240226:CREATE TABLE batchjob (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, endtime timestamp, exitcode varchar(2500), exitmessage varchar(2500), resulttype varchar(255), BUSINESS KEY(userid,mandant,buckr,jobname,starttime))
20240226:CREATE TABLE batchjobresult (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, data blob(67108864), BUSINESS KEY(userid,mandant,buckr,jobname,starttime))

20240226:CREATE VIEW standorte_view AS select bk.mandant, bk.buckr, g.gebaeude as standort1, e.etage as standort2, r.raum as standort3 from buchungskreise bk left join gebaeude g on g.mandant=bk.mandant and (g.haushalt=bk.buckr or g.haushalt='0000') left join etagen e on e.mandant=bk.mandant and (e.haushalt=bk.buckr or e.haushalt='0000') and e.gebaeude=g.gebaeude left join raeume r on r.mandant=bk.mandant and (r.haushalt=bk.buckr or r.haushalt='0000') and r.gebaeude=e.gebaeude and r.etage=e.etage
20240226:CREATE VIEW abiuebersicht_view AS select bk.mandant, bk.buckr, a.abinummer, gl.gangnr, a.zyklus, a.inventurleiter, gl.resourceid, a.status as abistatus, gl.status as gangstatus, rl.gebaeude as standort1, rl.etage as standort2, rl.raum as standort3, rl.status as standortstatus from buchungskreise bk left join abistamm a on a.mandant=bk.mandant and a.haushalt=bk.buckr left join gangliste gl on gl.mandant=bk.mandant and gl.haushalt=bk.buckr and gl.abinummer=a.abinummer left join raumliste rl on rl.mandant=bk.mandant and rl.haushalt=bk.buckr and rl.abinummer=gl.abinummer and rl.gangnr=gl.gangnr

20240314:ALTER TABLE benutzer ADD fromldap int

20240322:ALTER TABLE mandanten ADD sperruser varchar(50)
20240322:ALTER TABLE mandanten ADD sperrtext clob(64000)
20240322:UPDATE mandanten SET sperruser=(SELECT userid FROM sperre WHERE mandant=mandanten.mandant)
20240322:UPDATE mandanten SET sperrtext=(SELECT sperrtext FROM sperre WHERE mandant=mandanten.mandant)
20240322:ALTER TABLE btfsystem ADD infotext clob(64000)
20240322:UPDATE btfsystem SET infotext=(SELECT sperrtext FROM sperre WHERE mandant='' or mandant is null)
20240322:DROP TABLE sperre

20240417:RUN de.hallobtf.Kai.utils.convert.ConvertSuchkriterien
20240417:RUN de.hallobtf.Kai.utils.convert.ConvertBewegungen

20240920:ALTER TABLE abistamm DROP COLUMN datumzugang
20241011:DELETE FROM etityp WHERE etityp='@Hotfolder'
20241011:DELETE FROM etilay WHERE etityp='@Hotfolder'

20241202:MSSQL=ALTER TABLE suchfelder ALTER COLUMN suchfeld30 varchar(255)
20241202:DERBY=ALTER TABLE suchfelder ALTER COLUMN suchfeld30 set data type varchar(255)
20241202:ORACLE=ALTER TABLE suchfelder MODIFY suchfeld30 varchar(255 CHAR)
20241202:DEFAULT=ALTER TABLE suchfelder MODIFY suchfeld30 varchar(255)
20241202:DROP VIEW inventar_view
20241202:CREATE VIEW inventar_view AS SELECT i.*, f.fremdschluessel, s.suchfeld1, s.suchfeld2, s.suchfeld3, s.suchfeld4, s.suchfeld5, s.suchfeld6, s.suchfeld7, s.suchfeld8, s.suchfeld9, s.suchfeld10, s.suchfeld11, s.suchfeld12, s.suchfeld13, s.suchfeld14, s.suchfeld15, s.suchfeld16, s.suchfeld17, s.suchfeld18, s.suchfeld19, s.suchfeld20, s.suchfeld21, s.suchfeld22, s.suchfeld23, s.suchfeld24, s.suchfeld25, s.suchfeld26, s.suchfeld27, s.suchfeld28, s.suchfeld29, s.suchfeld30 FROM (inventar i left outer join inventarfremd f on i.mandant=f.mandant and i.nummer=f.nummer) LEFT OUTER JOIN suchfelder s ON i.mandant=s.mandant AND i.nummer=s.nummer

20241211:DROP TABLE batchjob
20241211:DROP TABLE batchjobresult
20241211:CREATE TABLE batchjob (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, endtime timestamp, exitcode varchar(2500), exitmessage varchar(2500), resulttype varchar(255), haserror int, BUSINESS KEY(userid,mandant,buckr,jobname,starttime))
20241211:CREATE TABLE batchjobresult (userid bigint, mandant varchar(3), buckr varchar(4), jobname varchar(100), starttime timestamp, result blob(67108864), error blob(67108864), BUSINESS KEY(userid,mandant,buckr,jobname,starttime))
20241211:DROP TABLE documenttemplate
20241211:DROP TABLE documenttemplatedata
20241211:CREATE TABLE documenttemplate(mandant varchar(3), buckr varchar(4), templateid varchar(36), name varchar(255), description varchar(255), title varchar(255), doctype varchar(10), doccat varchar(10), filename varchar(255), subscribed int, author varchar(50), lastmodifieddate timestamp, filesize int, BUSINESS KEY(mandant, buckr, templateid))
20241211:CREATE TABLE documenttemplatedata(mandant varchar(3), buckr varchar(4), templateid varchar(36), data blob(67108864), BUSINESS KEY(mandant, buckr, templateid))
20241211:CREATE UNIQUE INDEX idx_documenttemplate_name on documenttemplate (mandant,buckr,name)

20250123:ALTER TABLE batchjob ADD filenameprefix varchar(255)

20250317:UPDATE stapel set zuordnung='F' where zuordnung='?'

20250404:ALTER TABLE batchjob ADD hasprotocol int
20250404:ORACLE=ALTER TABLE batchjobresult ADD protocol blob
20250404:MSSQL=ALTER TABLE batchjobresult ADD protocol varbinary(max)
20250404:DERBY=ALTER TABLE batchjobresult ADD protocol blob
20250404:DEFAULT=ALTER TABLE batchjobresult ADD protocol longblob
20250404:RESETDEFAULT

20250409:ORACLE=ALTER TABLE batchjob ADD owner varchar(50 CHAR)
20250409:DEFAULT=ALTER TABLE batchjob ADD owner varchar(50)
20250409:RESETDEFAULT

20250411:ALTER TABLE mandanten ADD allowedfilepaths clob(64000)